/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.model.MemberCopierSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

public class ServiceModelCopiers {
    private final IntermediateModel intermediateModel;
    private final PoetExtension poetExtensions;
    private final TypeProvider typeProvider;

    public ServiceModelCopiers(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtension(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
    }

    public Collection<ClassSpec> copierSpecs() {
        HashMap memberSpecs = new HashMap();
        this.allShapeMembers().values().stream().filter(m -> !this.canCopyReference((MemberModel)m)).map(m -> new MemberCopierSpec((MemberModel)m, this, this.typeProvider, this.poetExtensions)).forEach(spec -> {
            ClassSpec cfr_ignored_0 = memberSpecs.put(spec.className(), spec);
        });
        return memberSpecs.values();
    }

    public Optional<ClassName> copierClassFor(MemberModel memberModel) {
        if (this.canCopyReference(memberModel)) {
            return Optional.empty();
        }
        String shapeName = memberModel.getC2jShape();
        if (shapeName.substring(0, 1).toLowerCase(Locale.ENGLISH).equals(shapeName.substring(0, 1))) {
            shapeName = "_" + shapeName;
        }
        return Optional.of(this.poetExtensions.getModelClass(shapeName + "Copier"));
    }

    public String copyMethodName() {
        return "copy";
    }

    public String enumToStringCopyMethodName() {
        return "copyEnumToString";
    }

    public String stringToEnumCopyMethodName() {
        return "copyStringToEnum";
    }

    public String copyFromBuilderMethodName() {
        return "copyFromBuilder";
    }

    public String copyToBuilderMethodName() {
        return "copyToBuilder";
    }

    private Map<String, MemberModel> allShapeMembers() {
        HashMap<String, MemberModel> shapeMembers = new HashMap<String, MemberModel>();
        this.intermediateModel.getShapes().values().stream().flatMap(s -> s.getMembersAsMap().values().stream()).forEach(m -> shapeMembers.put(m.getC2jShape(), (MemberModel)m));
        return shapeMembers;
    }

    private boolean canCopyReference(MemberModel m) {
        return !m.isList() && !m.isMap();
    }
}

