/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import software.amazon.awssdk.awscore.eventstream.RestEventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.model.config.customization.MetadataConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumRequiredTrait;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;
import software.amazon.awssdk.core.SdkPojoBuilder;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.VoidSdkResponse;
import software.amazon.awssdk.protocols.cbor.AwsCborProtocolFactory;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public class JsonProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;
    private final IntermediateModel model;

    public JsonProtocolSpec(PoetExtensions poetExtensions, IntermediateModel model) {
        this.poetExtensions = poetExtensions;
        this.model = model;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        ClassName baseException = this.baseExceptionClassName(model);
        Metadata metadata = model.getMetadata();
        ParameterizedTypeName upperBound = ParameterizedTypeName.get((ClassName)ClassName.get(BaseAwsJsonProtocolFactory.Builder.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{upperBound});
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").addTypeVariable(typeVariableName).addParameter((TypeName)typeVariableName, "builder", new Modifier[0]).returns((TypeName)typeVariableName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("return builder\n", new Object[0]).addCode(".clientConfiguration(clientConfiguration)\n", new Object[0]).addCode(".defaultServiceExceptionSupplier($T::builder)\n", new Object[]{baseException}).addCode(".protocol($T.$L)\n", new Object[]{AwsJsonProtocol.class, this.protocolEnumName(metadata.getProtocol())}).addCode(".protocolVersion($S)\n", new Object[]{metadata.getJsonVersion()}).addCode("$L", new Object[]{this.customErrorCodeFieldName()});
        String contentType = Optional.ofNullable(model.getCustomizationConfig().getCustomServiceMetadata()).map(MetadataConfig::getContentType).orElse(metadata.getContentType());
        if (contentType != null) {
            methodSpec.addCode(".contentType($S)", new Object[]{contentType});
        }
        this.registerModeledExceptions(model, this.poetExtensions).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(";", new Object[0]);
        return methodSpec.build();
    }

    private CodeBlock customErrorCodeFieldName() {
        return this.model.getCustomizationConfig().getCustomErrorCodeFieldName() == null ? CodeBlock.builder().build() : CodeBlock.of((String)".customErrorCodeFieldName($S)", (Object[])new Object[]{this.model.getCustomizationConfig().getCustomErrorCodeFieldName()});
    }

    private Class<?> protocolFactoryClass() {
        if (this.model.getMetadata().isCborProtocol()) {
            return AwsCborProtocolFactory.class;
        }
        return AwsJsonProtocolFactory.class;
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        TypeName pojoResponseType = this.getPojoResponseType(opModel, this.poetExtensions);
        String protocolFactory = this.protocolFactoryLiteral(model, opModel);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T operationMetadata = $T.builder()\n", new Object[]{JsonOperationMetadata.class, JsonOperationMetadata.class}).add(".hasStreamingSuccessResponse($L)\n", new Object[]{opModel.hasStreamingOutput()}).add(".isPayloadJson($L)\n", new Object[]{!opModel.getHasBlobMemberAsPayload()}).add(".build();", new Object[0]);
        if (opModel.hasEventStreamOutput()) {
            this.responseHandlersForEventStreaming(opModel, pojoResponseType, protocolFactory, builder);
        } else {
            builder.add("\n\n$T<$T> responseHandler = $L.createResponseHandler(operationMetadata, $T::builder);", new Object[]{HttpResponseHandler.class, pojoResponseType, protocolFactory, pojoResponseType});
        }
        return builder.build();
    }

    @Override
    public Optional<CodeBlock> errorResponseHandler(OperationModel opModel) {
        String protocolFactory = this.protocolFactoryLiteral(this.model, opModel);
        return Optional.of(CodeBlock.builder().add("\n\n$T<$T> errorResponseHandler = createErrorResponseHandler($L, operationMetadata);", new Object[]{HttpResponseHandler.class, AwsServiceException.class, protocolFactory}).build());
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        TypeName responseType = this.getPojoResponseType(opModel, this.poetExtensions);
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n", new Object[]{ClientExecutionParams.class, requestType, responseType}).add(".withOperationName(\"$N\")\n", new Object[]{opModel.getOperationName()}).add(".withResponseHandler(responseHandler)\n", new Object[0]).add(".withErrorResponseHandler(errorResponseHandler)\n", new Object[0]).add(this.hostPrefixExpression(opModel), new Object[0]).add(this.discoveredEndpoint(opModel), new Object[0]).add(".withInput($L)\n", new Object[]{opModel.getInput().getVariableName()}).add(".withMetricCollector(apiCallMetricCollector)", new Object[0]).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel));
        if (opModel.hasStreamingInput()) {
            codeBlock.add(".withRequestBody(requestBody)", new Object[0]).add(".withMarshaller($L)", new Object[]{this.syncStreamingMarshaller(this.model, opModel, marshaller)});
        } else {
            codeBlock.add(".withMarshaller(new $T(protocolFactory))", new Object[]{marshaller});
        }
        return codeBlock.add("$L);", new Object[]{opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        String customerResponseHandler;
        String whenComplete;
        boolean isRestJson = this.isRestJson(intermediateModel);
        TypeName pojoResponseType = this.getPojoResponseType(opModel, this.poetExtensions);
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (opModel.hasEventStreamOutput()) {
            ShapeModel shapeModel = EventStreamUtils.getEventStreamInResponse(opModel.getOutputShape());
            ClassName eventStreamBaseClass = this.poetExtensions.getModelClassFromShape(shapeModel);
            ParameterizedTypeName transformerType = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamAsyncResponseTransformer.class), (TypeName[])new TypeName[]{pojoResponseType, eventStreamBaseClass});
            builder.add("$1T<$2T> future = new $1T<>();", new Object[]{ClassName.get(CompletableFuture.class), ClassName.get(Void.class)}).add("$T asyncResponseTransformer = $T.<$T, $T>builder()\n", new Object[]{transformerType, ClassName.get(EventStreamAsyncResponseTransformer.class), pojoResponseType, eventStreamBaseClass}).add(".eventStreamResponseHandler(asyncResponseHandler)\n", new Object[0]).add(".eventResponseHandler(eventResponseHandler)\n", new Object[0]).add(".initialResponseHandler(responseHandler)\n", new Object[0]).add(".exceptionResponseHandler(errorResponseHandler)\n", new Object[0]).add(".future(future)\n", new Object[0]).add(".executor(executor)\n", new Object[0]).add(".serviceName(serviceName())\n", new Object[0]).add(".build();", new Object[0]);
            if (isRestJson) {
                builder.add(this.restAsyncResponseTransformer(pojoResponseType, eventStreamBaseClass));
            }
        }
        boolean isStreaming = opModel.hasStreamingOutput() || opModel.hasEventStreamOutput();
        String protocolFactory = this.protocolFactoryLiteral(intermediateModel, opModel);
        TypeName responseType = opModel.hasEventStreamOutput() && !isRestJson ? ClassName.get(SdkResponse.class) : pojoResponseType;
        TypeName executeFutureValueType = this.executeFutureValueType(opModel, this.poetExtensions);
        builder.add("\n\n$T<$T> executeFuture = clientHandler.execute(new $T<$T, $T>()\n", new Object[]{CompletableFuture.class, executeFutureValueType, ClientExecutionParams.class, requestType, responseType}).add(".withOperationName(\"$N\")\n", new Object[]{opModel.getOperationName()}).add(".withMarshaller($L)\n", new Object[]{this.asyncMarshaller(this.model, opModel, marshaller, protocolFactory)}).add(this.asyncRequestBody(opModel)).add(this.fullDuplex(opModel)).add(this.hasInitialRequestEvent(opModel, isRestJson)).add(".withResponseHandler($L)\n", new Object[]{this.responseHandlerName(opModel, isRestJson)}).add(".withErrorResponseHandler(errorResponseHandler)\n", new Object[0]).add(".withMetricCollector(apiCallMetricCollector)\n", new Object[0]).add(this.hostPrefixExpression(opModel), new Object[0]).add(this.discoveredEndpoint(opModel), new Object[0]).add(asyncRequestBody, new Object[0]).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel)).add(".withInput($L)$L);", new Object[]{opModel.getInput().getVariableName(), this.asyncResponseTransformerVariable(isStreaming, isRestJson, opModel)});
        if (opModel.hasStreamingOutput()) {
            builder.addStatement("$T<$T, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer", new Object[]{AsyncResponseTransformer.class, pojoResponseType});
        }
        if (!(whenComplete = this.whenCompleteBody(opModel, customerResponseHandler = opModel.hasEventStreamOutput() ? "asyncResponseHandler" : "finalAsyncResponseTransformer")).isEmpty()) {
            String whenCompletedFutureName = "whenCompleted";
            builder.addStatement("$T<$T> $N = $N$L", new Object[]{CompletableFuture.class, executeFutureValueType, whenCompletedFutureName, "executeFuture", whenComplete});
            builder.addStatement("executeFuture = $T.forwardExceptionTo($N, executeFuture)", new Object[]{CompletableFutureUtils.class, whenCompletedFutureName});
        }
        if (opModel.hasEventStreamOutput()) {
            builder.addStatement("return $T.forwardExceptionTo(future, executeFuture)", new Object[]{CompletableFutureUtils.class});
        } else {
            builder.addStatement("return executeFuture", new Object[0]);
        }
        return builder.build();
    }

    private String responseHandlerName(OperationModel opModel, boolean isRestJson) {
        return opModel.hasEventStreamOutput() && !isRestJson ? "voidResponseHandler" : "responseHandler";
    }

    private CodeBlock fullDuplex(OperationModel opModel) {
        return opModel.hasEventStreamInput() && opModel.hasEventStreamOutput() ? CodeBlock.of((String)".withFullDuplex(true)", (Object[])new Object[0]) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private CodeBlock hasInitialRequestEvent(OperationModel opModel, boolean isRestJson) {
        return opModel.hasEventStreamInput() && !isRestJson ? CodeBlock.of((String)".withInitialRequestEvent(true)", (Object[])new Object[0]) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private CodeBlock asyncRequestBody(OperationModel opModel) {
        return opModel.hasEventStreamInput() ? CodeBlock.of((String)".withAsyncRequestBody($T.fromPublisher(adapted))", (Object[])new Object[]{AsyncRequestBody.class}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private String asyncResponseTransformerVariable(boolean isStreaming, boolean isRestJson, OperationModel opModel) {
        if (isStreaming) {
            if (opModel.hasEventStreamOutput() && isRestJson) {
                return ", restAsyncResponseTransformer";
            }
            return ", asyncResponseTransformer";
        }
        return "";
    }

    private CodeBlock restAsyncResponseTransformer(TypeName pojoResponseType, ClassName eventStreamBaseClass) {
        ParameterizedTypeName restTransformerType = ParameterizedTypeName.get((ClassName)ClassName.get(RestEventStreamAsyncResponseTransformer.class), (TypeName[])new TypeName[]{pojoResponseType, eventStreamBaseClass});
        return CodeBlock.builder().add("$T restAsyncResponseTransformer = $T.<$T, $T>builder()\n", new Object[]{restTransformerType, ClassName.get(RestEventStreamAsyncResponseTransformer.class), pojoResponseType, eventStreamBaseClass}).add(".eventStreamAsyncResponseTransformer(asyncResponseTransformer)\n", new Object[0]).add(".eventStreamResponseHandler(asyncResponseHandler)\n", new Object[0]).add(".build();", new Object[0]).build();
    }

    private String whenCompleteBody(OperationModel operationModel, String responseHandlerName) {
        if (operationModel.hasEventStreamOutput()) {
            return this.eventStreamOutputWhenComplete(responseHandlerName);
        }
        if (operationModel.hasStreamingOutput()) {
            return this.streamingOutputWhenComplete(responseHandlerName);
        }
        return this.publishMetricsWhenComplete();
    }

    private String eventStreamOutputWhenComplete(String responseHandlerName) {
        return String.format(".whenComplete((r, e) -> {%n     if (e != null) {%n         try {             %s.exceptionOccurred(e);%n         } finally {             future.completeExceptionally(e);         }     }%s})", responseHandlerName, this.publishMetrics());
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        ClassName httpResponseHandler = ClassName.get(HttpResponseHandler.class);
        ClassName sdkBaseException = ClassName.get(AwsServiceException.class);
        ParameterizedTypeName responseHandlerOfException = ParameterizedTypeName.get((ClassName)httpResponseHandler, (TypeName[])new TypeName[]{sdkBaseException});
        return Optional.of(MethodSpec.methodBuilder((String)"createErrorResponseHandler").addParameter(BaseAwsJsonProtocolFactory.class, "protocolFactory", new Modifier[0]).addParameter(JsonOperationMetadata.class, "operationMetadata", new Modifier[0]).returns((TypeName)responseHandlerOfException).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return protocolFactory.createErrorResponseHandler(operationMetadata)", new Object[0]).build());
    }

    private String protocolEnumName(Protocol protocol) {
        switch (protocol) {
            case CBOR: 
            case AWS_JSON: {
                return Protocol.AWS_JSON.name();
            }
        }
        return protocol.name();
    }

    private ClassName baseExceptionClassName(IntermediateModel model) {
        String exceptionPath = model.getSdkModeledExceptionBaseFqcn().substring(0, model.getSdkModeledExceptionBaseFqcn().lastIndexOf(46));
        return ClassName.get((String)exceptionPath, (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]);
    }

    private void responseHandlersForEventStreaming(OperationModel opModel, TypeName pojoResponseType, String protocolFactory, CodeBlock.Builder builder) {
        builder.add("\n\n$T<$T> responseHandler = new $T($L.createResponseHandler(operationMetadata, $T::builder));", new Object[]{HttpResponseHandler.class, pojoResponseType, AttachHttpMetadataResponseHandler.class, protocolFactory, pojoResponseType});
        builder.add("\n\n$T<$T> voidResponseHandler = $L.createResponseHandler($T.builder()\n                                   .isPayloadJson(false)\n                                   .hasStreamingSuccessResponse(true)\n                                   .build(), $T::builder);", new Object[]{HttpResponseHandler.class, SdkResponse.class, protocolFactory, JsonOperationMetadata.class, VoidSdkResponse.class});
        ShapeModel eventStream = EventStreamUtils.getEventStreamInResponse(opModel.getOutputShape());
        ClassName eventStreamBaseClass = this.poetExtensions.getModelClassFromShape(eventStream);
        builder.add("\n\n$T<$T> eventResponseHandler = $L.createResponseHandler($T.builder()\n                                   .isPayloadJson(true)\n                                   .hasStreamingSuccessResponse(false)\n                                   .build(), $T.builder()", new Object[]{HttpResponseHandler.class, WildcardTypeName.subtypeOf((TypeName)eventStreamBaseClass), protocolFactory, JsonOperationMetadata.class, ClassName.get(EventStreamTaggedUnionPojoSupplier.class)});
        EventStreamSpecHelper eventStreamSpecHelper = new EventStreamSpecHelper(eventStream, this.model);
        EventStreamUtils.getEventMembers(eventStream).forEach(m -> {
            String builderMethod = eventStreamSpecHelper.eventBuilderMethodName((MemberModel)m);
            builder.add(".putSdkPojoSupplier($S, $T::$N)", new Object[]{m.getC2jName(), eventStreamBaseClass, builderMethod});
        });
        builder.add(".defaultSdkPojoSupplier(() -> new $T($T.UNKNOWN))\n.build());\n", new Object[]{SdkPojoBuilder.class, eventStreamBaseClass});
    }

    private String protocolFactoryLiteral(IntermediateModel model, OperationModel opModel) {
        if ("Kinesis".equals(model.getMetadata().getServiceId()) && opModel.hasEventStreamOutput()) {
            return "jsonProtocolFactory";
        }
        return "protocolFactory";
    }

    private boolean isRestJson(IntermediateModel model) {
        return model.getMetadata().getProtocol() == Protocol.REST_JSON;
    }
}

