/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.common.EnumClass;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceModel;
import software.amazon.awssdk.codegen.poet.model.ResponseMetadataSpec;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.utils.FunctionalUtils;

class ModelClassGeneratorTasks
extends BaseGeneratorTasks {
    private final String modelClassDir;

    ModelClassGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.modelClassDir = dependencies.getPathProvider().getModelDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(new PoetGeneratorTask(this.modelClassDir, this.model.getFileHeader(), new AwsServiceBaseRequestSpec(this.model)));
        tasks.add(new PoetGeneratorTask(this.modelClassDir, this.model.getFileHeader(), new AwsServiceBaseResponseSpec(this.model)));
        this.model.getShapes().values().stream().filter(this::shouldGenerateShape).map(FunctionalUtils.safeFunction(this::createTask)).forEach(tasks::add);
        new ServiceModelCopiers(this.model).copierSpecs().stream().map(FunctionalUtils.safeFunction(spec -> new PoetGeneratorTask(this.modelClassDir, this.model.getFileHeader(), (ClassSpec)spec))).forEach(tasks::add);
        tasks.add(new PoetGeneratorTask(this.modelClassDir, this.model.getFileHeader(), new ResponseMetadataSpec(this.model)));
        return tasks;
    }

    private boolean shouldGenerateShape(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingModelClass()) {
            this.info("Skip generating class " + shapeModel.getShapeName());
            return false;
        }
        return true;
    }

    private GeneratorTask createTask(ShapeModel shapeModel) throws IOException {
        Metadata metadata = this.model.getMetadata();
        ClassSpec classSpec = shapeModel.getShapeType() == ShapeType.Enum ? new EnumClass(metadata.getFullModelPackageName(), shapeModel) : new AwsServiceModel(this.model, shapeModel);
        return new PoetGeneratorTask(this.modelClassDir, this.model.getFileHeader(), classSpec);
    }
}

