/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.emitters.CodeTransformer;

public class UnusedImportRemover
implements CodeTransformer {
    private static Pattern IMPORT_PATTERN = Pattern.compile("import(?:\\s+)(?:static\\s+)?(.*)(?:\\s*);");

    @Override
    public String apply(String content) {
        return (String)this.findUnusedImports(content).stream().map(this::removeImportFunction).reduce(Function.identity(), Function::andThen).apply(content);
    }

    private Function<String, String> removeImportFunction(String importToRemove) {
        return c -> c.replaceFirst(this.findSpecificImportRegex(importToRemove), "");
    }

    private Set<String> findUnusedImports(String content) {
        return this.findImports(content).stream().filter(this.isUnused(content)).collect(Collectors.toSet());
    }

    private List<String> findImports(String content) {
        Matcher m = IMPORT_PATTERN.matcher(content);
        ArrayList<String> imports = new ArrayList<String>();
        while (m.find()) {
            imports.add(m.group(1));
        }
        return imports;
    }

    private String removeAllImports(String content) {
        return content.replaceAll(IMPORT_PATTERN.pattern(), "");
    }

    private Predicate<String> isUnused(String content) {
        String contentWithoutImports = this.removeAllImports(content);
        return importToCheck -> !importToCheck.contains("*") && (this.isNotReferenced(contentWithoutImports, (String)importToCheck) || this.isDuplicate(content, (String)importToCheck));
    }

    private boolean isNotReferenced(String contentWithoutImports, String importToCheck) {
        String symbol = importToCheck.substring(importToCheck.lastIndexOf(".") + 1);
        return !Pattern.compile(String.format("\\b%s\\b", symbol)).matcher(contentWithoutImports).find();
    }

    private boolean isDuplicate(String content, String importToCheck) {
        Matcher m = Pattern.compile(this.findSpecificImportRegex(importToCheck)).matcher(content);
        return m.find() && m.find();
    }

    private String findSpecificImportRegex(String specificImport) {
        return String.format("import(?:\\s+)(?:static )?(?:%s)(?:\\s*);", specificImport);
    }
}

