/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;

public class EventStreamUtils {
    private final OperationModel operation;
    private final PoetExtensions poetExt;

    private EventStreamUtils(PoetExtensions poetExt, OperationModel eventStreamOperation) {
        this.operation = eventStreamOperation;
        this.poetExt = poetExt;
    }

    public String getApiName() {
        return Utils.capitalize(this.operation.getOperationName());
    }

    public ShapeModel getEventStreamShape() {
        ShapeModel outputShape = this.operation.getOutputShape();
        return outputShape.getMembers().stream().map(MemberModel::getShape).filter(Objects::nonNull).filter(ShapeModel::isEventStream).findFirst().orElseThrow(() -> new IllegalStateException("Did not find event stream member on " + outputShape.getC2jName()));
    }

    public Stream<ShapeModel> getEventSubTypes() {
        return this.getEventStreamMembers().map(MemberModel::getShape);
    }

    public Stream<MemberModel> getEventStreamMembers() {
        return this.getEventStreamShape().getMembers().stream().filter(m -> m.getShape() != null && m.getShape().isEvent());
    }

    public ClassName responsePojoType() {
        return this.poetExt.getModelClass(this.operation.getOutputShape().getShapeName());
    }

    public ClassName eventStreamBaseClass() {
        return this.poetExt.getModelClass(this.getEventStreamShape().getShapeName());
    }

    public ClassName responseHandlerType() {
        return this.poetExt.getModelClass(this.getApiName() + "ResponseHandler");
    }

    public ClassName responseHandlerBuilderType() {
        return this.responseHandlerType().nestedClass("Builder");
    }

    public ClassName responseHandlerVisitorType() {
        return this.responseHandlerType().nestedClass("Visitor");
    }

    public ClassName responseHandlerVisitorBuilderType() {
        return this.responseHandlerVisitorType().nestedClass("Builder");
    }

    public static EventStreamUtils create(PoetExtensions poetExt, OperationModel eventStreamOperation) {
        return new EventStreamUtils(poetExt, eventStreamOperation);
    }

    public static EventStreamUtils createFromEventStreamShape(PoetExtensions poetExt, IntermediateModel model, ShapeModel eventStreamShape) {
        return new EventStreamUtils(poetExt, EventStreamUtils.findEventStreamOperation(model, eventStreamShape));
    }

    public static EventStreamUtils createFromEventShape(PoetExtensions poetExt, IntermediateModel model, ShapeModel eventSubTypeShape) {
        ShapeModel parentEventStreamShape = EventStreamUtils.findBaseEventStreamShape(model, eventSubTypeShape);
        return EventStreamUtils.createFromEventStreamShape(poetExt, model, parentEventStreamShape);
    }

    private static ShapeModel findBaseEventStreamShape(IntermediateModel model, ShapeModel eventStreamShape) {
        return model.getShapes().values().stream().filter(ShapeModel::isEventStream).filter(s -> s.getMembers().stream().anyMatch(m -> m.getShape().equals(eventStreamShape))).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Event shape %s not referenced in model by eventstream shape", eventStreamShape.getC2jName())));
    }

    private static OperationModel findEventStreamOperation(IntermediateModel model, ShapeModel eventSubTypeShape) {
        return model.getOperations().values().stream().filter(o -> o.getOutputShape() != null && o.getOutputShape().getMembers() != null).filter(o -> o.getOutputShape().getMembers().stream().filter(m -> m.getShape() != null).filter(m -> m.getShape().equals(eventSubTypeShape)).anyMatch(m -> m.getShape().isEventStream())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("%s is an eventstream shape but has no corresponding operation in the model", eventSubTypeShape.getC2jName())));
    }
}

