/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.naming;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static Logger log = Logger.loggerFor(DefaultNamingStrategy.class);
    private static final Set<String> RESERVED_KEYWORDS;
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;

    public DefaultNamingStrategy(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig;
    }

    private static boolean isJavaKeyword(String word) {
        return RESERVED_KEYWORDS.contains(word) || RESERVED_KEYWORDS.contains(StringUtils.lowerCase((String)word));
    }

    @Override
    @ReviewBeforeRelease(value="Always use service ID as the base.")
    public String getServiceName() {
        String baseName = Stream.of(this.serviceModel.getMetadata().getServiceId(), this.serviceModel.getMetadata().getServiceAbbreviation(), this.serviceModel.getMetadata().getServiceFullName()).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("No non-null service name descriptor."));
        baseName = this.pascalCase(this.splitOnWordBoundaries(baseName));
        baseName = Utils.removeLeading(baseName, "Amazon");
        baseName = Utils.removeLeading(baseName, "Aws");
        baseName = Utils.removeTrailing(baseName, "Service");
        return baseName;
    }

    @Override
    public String getClientPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s");
    }

    @Override
    public String getModelPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.model");
    }

    @Override
    public String getTransformPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.transform");
    }

    @Override
    public String getRequestTransformPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.transform");
    }

    @Override
    public String getPaginatorsPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.paginators");
    }

    @Override
    public String getSmokeTestPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.smoketests");
    }

    private String concatServiceNameIfShareModel(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null) {
            return this.customizationConfig.getShareModelConfig().getShareModelWith() + "." + Optional.ofNullable(this.customizationConfig.getShareModelConfig().getPackageName()).orElse(serviceName);
        }
        return serviceName;
    }

    private String pascalCase(String word) {
        return Stream.of(this.splitOnWordBoundaries(word)).map(StringUtils::lowerCase).map(Utils::capitalize).collect(Collectors.joining());
    }

    private String pascalCase(String ... words) {
        return Stream.of(words).map(StringUtils::lowerCase).map(Utils::capitalize).collect(Collectors.joining());
    }

    private String getCustomizedPackageName(String serviceName, String defaultPattern) {
        return String.format(defaultPattern, StringUtils.lowerCase((String)serviceName));
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        if (errorShapeName.endsWith("Fault")) {
            return this.pascalCase(errorShapeName.substring(0, errorShapeName.length() - "Fault".length())) + "Exception";
        }
        if (errorShapeName.endsWith("Exception")) {
            return this.pascalCase(errorShapeName);
        }
        return this.pascalCase(errorShapeName) + "Exception";
    }

    @Override
    public String getRequestClassName(String operationName) {
        return this.pascalCase(operationName) + "Request";
    }

    @Override
    public String getResponseClassName(String operationName) {
        return this.pascalCase(operationName) + "Response";
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name)) {
            return Utils.unCapitalize(name + "Value");
        }
        return Utils.unCapitalize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        String result = enumValue;
        result = result.replaceAll("textORcsv", "TEXT_OR_CSV");
        result = String.join((CharSequence)"_", this.splitOnWordBoundaries(result));
        if (!(result = StringUtils.upperCase((String)result)).matches("^[A-Z][A-Z0-9_]*$")) {
            String attempt = result;
            log.warn(() -> "Invalid enum member generated for input '" + enumValue + "'. Best attempt: '" + attempt + "' If this enum is not customized out, the build will fail.");
        }
        return result;
    }

    @Override
    public String getJavaClassName(String shapeName) {
        return Arrays.stream(shapeName.split("[._-]|\\W")).map(Utils::capitalize).collect(Collectors.joining());
    }

    @Override
    public String getAuthorizerClassName(String shapeName) {
        String converted = this.getJavaClassName(shapeName);
        if (converted.length() > 0 && !Character.isLetter(converted.charAt(0))) {
            return "I" + converted;
        }
        return converted;
    }

    @Override
    public String getFluentGetterMethodName(String memberName, Shape shape) {
        String getterMethodName = Utils.unCapitalize(memberName);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            getterMethodName = getterMethodName + "AsString";
            if (Utils.isListShape(shape) || Utils.isMapShape(shape)) {
                getterMethodName = getterMethodName + "s";
            }
        }
        return getterMethodName;
    }

    @Override
    public String getFluentEnumGetterMethodName(String memberName, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        return Utils.unCapitalize(memberName);
    }

    @Override
    public String getBeanStyleGetterMethodName(String memberName) {
        return String.format("get%s", Utils.capitalize(memberName));
    }

    @Override
    public String getSetterMethodName(String memberName) {
        return Utils.unCapitalize(memberName);
    }

    @Override
    public String getBeanStyleSetterMethodName(String memberName) {
        return String.format("set%s", Utils.capitalize(memberName));
    }

    @Override
    public String getFluentSetterMethodName(String memberName, Shape shape) {
        String setterMethodName = Utils.unCapitalize(memberName);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes()) && (Utils.isListShape(shape) || Utils.isMapShape(shape))) {
            setterMethodName = setterMethodName + "WithStrings";
        }
        return setterMethodName;
    }

    @Override
    public String getFluentEnumSetterMethodName(String memberName, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        return Utils.unCapitalize(memberName);
    }

    private String[] splitOnWordBoundaries(String toSplit) {
        String result = toSplit;
        result = result.replaceAll("[^A-Za-z0-9]+", " ");
        result = result.replaceAll("([^a-z]{2,})v([0-9]+)", "$1 v$2 ").replaceAll("([^A-Z]{2,})V([0-9]+)", "$1 V$2 ");
        result = String.join((CharSequence)" ", result.split("(?<=[a-z])(?=[A-Z]([a-zA-Z]|[0-9]))"));
        result = result.replaceAll("([A-Z]+)([A-Z][a-z])", "$1 $2");
        result = result.replaceAll("([0-9])([a-zA-Z])", "$1 $2");
        result = result.replaceAll(" +", " ").trim();
        return result.split(" ");
    }

    static {
        HashSet keywords = new HashSet();
        Collections.addAll(keywords, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "null", "false", "const", "goto");
        RESERVED_KEYWORDS = Collections.unmodifiableSet(keywords);
    }
}

