/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import software.amazon.awssdk.utils.StringUtils;

public enum AuthType {
    NONE("none"),
    CUSTOM("custom"),
    IAM("iam"),
    V2("v2"),
    V3("v3"),
    V3_HTTPS("v3https"),
    V4("v4"),
    S3("s3");

    private final String value;

    private AuthType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static AuthType fromValue(String value) {
        String normalizedValue = StringUtils.lowerCase((String)value);
        return Arrays.stream(AuthType.values()).filter(authType -> authType.value.equals(normalizedValue)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown AuthType '%s'", normalizedValue)));
    }
}

