/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.internal.Constants;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.ParameterHttpMapping;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.utils.StringUtils;

public class MemberModel
extends DocumentationModel {
    private String name;
    private String c2jName;
    private String c2jShape;
    private VariableModel variable;
    private VariableModel setterModel;
    private ReturnTypeModel getterModel;
    private ParameterHttpMapping http;
    private boolean deprecated;
    private ListModel listModel;
    private MapModel mapModel;
    private String enumType;
    private String xmlNameSpaceUri;
    private boolean idempotencyToken;
    private ShapeModel shape;
    private String fluentGetterMethodName;
    private String fluentEnumGetterMethodName;
    private String fluentSetterMethodName;
    private String beanStyleGetterName;
    private String beanStyleSetterName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MemberModel withName(String name) {
        this.setName(name);
        return this;
    }

    public String getC2jName() {
        return this.c2jName;
    }

    public void setC2jName(String c2jName) {
        this.c2jName = c2jName;
    }

    public MemberModel withC2jName(String c2jName) {
        this.setC2jName(c2jName);
        return this;
    }

    public String getC2jShape() {
        return this.c2jShape;
    }

    public void setC2jShape(String c2jShape) {
        this.c2jShape = c2jShape;
    }

    public MemberModel withC2jShape(String c2jShape) {
        this.setC2jShape(c2jShape);
        return this;
    }

    public VariableModel getVariable() {
        return this.variable;
    }

    public void setVariable(VariableModel variable) {
        this.variable = variable;
    }

    public MemberModel withVariable(VariableModel variable) {
        this.setVariable(variable);
        return this;
    }

    public VariableModel getSetterModel() {
        return this.setterModel;
    }

    public void setSetterModel(VariableModel setterModel) {
        this.setterModel = setterModel;
    }

    public MemberModel withSetterModel(VariableModel setterModel) {
        this.setSetterModel(setterModel);
        return this;
    }

    public String getFluentGetterMethodName() {
        return this.fluentGetterMethodName;
    }

    public void setFluentGetterMethodName(String fluentGetterMethodName) {
        this.fluentGetterMethodName = fluentGetterMethodName;
    }

    public MemberModel withFluentGetterMethodName(String getterMethodName) {
        this.setFluentGetterMethodName(getterMethodName);
        return this;
    }

    public String getFluentEnumGetterMethodName() {
        return this.fluentEnumGetterMethodName;
    }

    public void setFluentEnumGetterMethodName(String fluentEnumGetterMethodName) {
        this.fluentEnumGetterMethodName = fluentEnumGetterMethodName;
    }

    public MemberModel withFluentEnumGetterMethodName(String fluentEnumGetterMethodName) {
        this.setFluentEnumGetterMethodName(fluentEnumGetterMethodName);
        return this;
    }

    public String getBeanStyleGetterMethodName() {
        return this.beanStyleGetterName;
    }

    public void setBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
    }

    public MemberModel withBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
        return this;
    }

    public String getBeanStyleSetterMethodName() {
        return this.beanStyleSetterName;
    }

    public void setBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
    }

    public MemberModel withBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
        return this;
    }

    public String getSetterMethodName() {
        return this.getBeanStyleSetterMethodName();
    }

    public void setSetterMethodName(String setterMethodName) {
        this.setBeanStyleGetterMethodName(setterMethodName);
    }

    public MemberModel withSetterMethodName(String setterMethodName) {
        this.setSetterMethodName(setterMethodName);
        return this;
    }

    public String getFluentSetterMethodName() {
        return this.fluentSetterMethodName;
    }

    public void setFluentSetterMethodName(String fluentSetterMethodName) {
        this.fluentSetterMethodName = fluentSetterMethodName;
    }

    public MemberModel withFluentSetterMethodName(String fluentMethodName) {
        this.setFluentSetterMethodName(fluentMethodName);
        return this;
    }

    public ReturnTypeModel getGetterModel() {
        return this.getterModel;
    }

    public void setGetterModel(ReturnTypeModel getterModel) {
        this.getterModel = getterModel;
    }

    public MemberModel withGetterModel(ReturnTypeModel getterModel) {
        this.setGetterModel(getterModel);
        return this;
    }

    public ParameterHttpMapping getHttp() {
        return this.http;
    }

    public void setHttp(ParameterHttpMapping parameterHttpMapping) {
        this.http = parameterHttpMapping;
    }

    public boolean isSimple() {
        return TypeUtils.isSimple(this.variable.getVariableType());
    }

    public boolean isList() {
        return this.listModel != null;
    }

    public boolean isMap() {
        return this.mapModel != null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public MemberModel withListModel(ListModel list) {
        this.setListModel(list);
        return this;
    }

    public MapModel getMapModel() {
        return this.mapModel;
    }

    public void setMapModel(MapModel map) {
        this.mapModel = map;
    }

    public MemberModel withMapModel(MapModel map) {
        this.setMapModel(map);
        return this;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public MemberModel withEnumType(String enumType) {
        this.setEnumType(enumType);
        return this;
    }

    public String getXmlNameSpaceUri() {
        return this.xmlNameSpaceUri;
    }

    public void setXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.xmlNameSpaceUri = xmlNameSpaceUri;
    }

    public MemberModel withXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.setXmlNameSpaceUri(xmlNameSpaceUri);
        return this;
    }

    public String getSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : "Sets the value of the %s property for this object.".replace("%s", this.name) + "\n");
        if (this.returnTypeIs(ByteBuffer.class)) {
            this.appendParagraph(docBuilder, "To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when set.", new Object[0]);
        }
        docBuilder.append(this.getParamDoc()).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    public String getGetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : "Returns the value of the %s property for this object.".replace("%s", this.name)).append(Constants.LF);
        if (this.returnTypeIs(ByteBuffer.class)) {
            this.appendParagraph(docBuilder, "This method will return a new read-only {@code ByteBuffer} each time it is invoked.", new Object[0]);
        } else if (this.returnTypeIs(List.class) || this.returnTypeIs(Map.class)) {
            this.appendParagraph(docBuilder, "Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.", new Object[0]);
        }
        if (this.enumType != null) {
            if (this.returnTypeIs(List.class)) {
                this.appendParagraph(docBuilder, "If the list returned by the service includes enum values that are not available in the current SDK version, {@link #%s} will use {@link %s#UNKNOWN_TO_SDK_VERSION} in place of those values in the list. The raw values returned by the service are available from {@link #%s}.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            } else if (this.returnTypeIs(Map.class)) {
                this.appendParagraph(docBuilder, "If the map returned by the service includes enum values that are not available in the current SDK version, {@link #%s} will not include those keys in the map. {@link #%s} will include all data from the service.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            } else {
                this.appendParagraph(docBuilder, "If the service returns an enum value that is not available in the current SDK version, {@link #%s} will return {@link %s#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #%s}.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            }
        }
        String variableDesc = StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : "The value of the %s property for this object.".replace("%s", this.name);
        docBuilder.append("@return ").append(DocumentationUtils.stripHtmlTags(variableDesc)).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    private boolean returnTypeIs(Class<?> clazz) {
        String returnType = this.getGetterModel().getReturnType();
        return returnType != null && returnType.startsWith(clazz.getName());
    }

    public String getFluentSetterDocumentation() {
        return this.getSetterDocumentation() + Constants.LF + "@return " + DocumentationUtils.stripHtmlTags("Returns a reference to this object so that method calls can be chained together.") + this.getEnumDoc();
    }

    public String getDefaultConsumerFluentSetterDocumentation() {
        return (StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : "Sets the value of the %s property for this object.".replace("%s", this.name) + "\n") + Constants.LF + "This is a convenience that creates an instance of the {@link " + this.variable.getSimpleType() + ".Builder} avoiding the need to create one manually via {@link " + this.variable.getSimpleType() + "#builder()}.\n" + Constants.LF + "When the {@link Consumer} completes, {@link " + this.variable.getSimpleType() + ".Builder#build()} is called immediately and its result is passed to {@link #" + this.getFluentGetterMethodName() + "(" + this.variable.getSimpleType() + ")}." + Constants.LF + "@param " + this.variable.getVariableName() + " a consumer that will call methods on {@link " + this.variable.getSimpleType() + ".Builder}" + Constants.LF + "@return " + DocumentationUtils.stripHtmlTags("Returns a reference to this object so that method calls can be chained together.") + Constants.LF + "@see #" + this.getFluentSetterMethodName() + "(" + this.variable.getSimpleType() + ")";
    }

    private String getParamDoc() {
        return Constants.LF + "@param " + this.variable.getVariableName() + " " + DocumentationUtils.stripHtmlTags(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : "The new value for the %s property for this object.".replace("%s", this.name));
    }

    private String getEnumDoc() {
        StringBuilder docBuilder = new StringBuilder();
        if (this.enumType != null) {
            docBuilder.append(Constants.LF).append("@see ").append(this.enumType);
        }
        return docBuilder.toString();
    }

    public boolean isIdempotencyToken() {
        return this.idempotencyToken;
    }

    public void setIdempotencyToken(boolean idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public boolean getIsBinary() {
        return this.http.getIsStreaming() || this.http.getIsPayload() && "java.nio.ByteBuffer".equals(this.variable.getVariableType());
    }

    @JsonIgnore
    public String getPathMarshaller() {
        if (!this.http.isUri()) {
            throw new IllegalStateException("Only members bound to the URI have a path marshaller");
        }
        String prefix = PathMarshallers.class.getName();
        if (this.http.isGreedy()) {
            return prefix + ".GREEDY";
        }
        if (this.isIdempotencyToken()) {
            return prefix + ".IDEMPOTENCY";
        }
        return prefix + ".NON_GREEDY";
    }

    @JsonIgnore
    public String getMarshallerBindingFieldName() {
        return StringUtils.upperCase((String)this.name) + "_BINDING";
    }

    @JsonIgnore
    public boolean hasBuilder() {
        return !this.isSimple() && !this.isList() && !this.isMap();
    }

    @JsonIgnore
    public boolean isCollectionWithBuilderMember() {
        return this.isList() && this.getListModel().getListMemberModel() != null && this.getListModel().getListMemberModel().hasBuilder() || this.isMap() && this.getMapModel().getValueModel() != null && this.getMapModel().getValueModel().hasBuilder();
    }

    public String getMarshallingType() {
        if (this.isList()) {
            return "LIST";
        }
        if (this.isMap()) {
            return "MAP";
        }
        if (!this.isSimple()) {
            return "STRUCTURED";
        }
        return TypeUtils.getMarshallingType(this.variable.getSimpleType());
    }

    public String getMarshallingTargetClass() {
        if (this.isList()) {
            return "List";
        }
        if (this.isMap()) {
            return "Map";
        }
        if (!this.isSimple()) {
            return "StructuredPojo";
        }
        return this.variable.getVariableType();
    }

    @JsonIgnore
    public ShapeModel getShape() {
        return this.shape;
    }

    public void setShape(ShapeModel shape) {
        this.shape = shape;
    }

    public String toString() {
        return this.c2jName;
    }

    private void appendParagraph(StringBuilder builder, String content, Object ... contentArgs) {
        builder.append("<p>").append(Constants.LF).append(String.format(content, contentArgs)).append(Constants.LF).append("</p>").append(Constants.LF);
    }
}

