/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import freemarker.template.Template;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.transform.JsonModelMarshallerSpec;
import software.amazon.awssdk.codegen.poet.transform.MarshallerSpec;
import software.amazon.awssdk.core.util.ImmutableMapParameter;
import software.amazon.awssdk.utils.FunctionalUtils;

public class MarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final String transformClassDir;
    private final Metadata metadata;
    private final Map<String, ShapeModel> shapes;

    public MarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.transformClassDir = dependencies.getPathProvider().getTransformDirectory();
        this.metadata = this.model.getMetadata();
        this.shapes = this.model.getShapes();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting marshaller classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).flatMap(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingMarshaller()) {
            this.info("Skip generating marshaller class for " + shapeModel.getShapeName());
            return false;
        }
        return this.shouldGenerate(shapeModel.getShapeType());
    }

    private boolean shouldGenerate(ShapeType shapeType) {
        return ShapeType.Request == shapeType || ShapeType.Model == shapeType && this.metadata.isJsonProtocol();
    }

    private Stream<GeneratorTask> createTask(String javaShapeName, ShapeModel shapeModel) throws Exception {
        if (this.metadata.isJsonProtocol()) {
            return ShapeType.Request == shapeModel.getShapeType() ? Stream.of(this.createPoetGeneratorTask(new JsonModelMarshallerSpec(this.model, shapeModel, "ModelMarshaller")), this.createPoetGeneratorTask(new MarshallerSpec(this.model, shapeModel))) : Stream.of(this.createPoetGeneratorTask(new JsonModelMarshallerSpec(this.model, shapeModel, "Marshaller")));
        }
        return Stream.of(this.createMarshallerTask(javaShapeName, this.freemarker.getModelMarshallerTemplate(), javaShapeName + "Marshaller", this.transformClassDir));
    }

    private GeneratorTask createMarshallerTask(String javaShapeName, Template template, String marshallerClassName, String marshallerDirectory) throws IOException {
        ImmutableMapParameter marshallerDataModel = ImmutableMapParameter.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shapeName", (Object)javaShapeName).put((Object)"shapes", this.shapes).put((Object)"metadata", (Object)this.metadata).put((Object)"transformPackage", (Object)this.model.getMetadata().getFullTransformPackageName()).put((Object)"requestTransformPackage", (Object)this.model.getMetadata().getFullRequestTransformPackageName()).put((Object)"customConfig", (Object)this.model.getCustomizationConfig()).put((Object)"className", (Object)marshallerClassName).put((Object)"protocolEnum", (Object)this.getProtocolEnumName()).build();
        return new FreemarkerGeneratorTask(marshallerDirectory, marshallerClassName, template, marshallerDataModel);
    }

    private String getProtocolEnumName() {
        switch (this.metadata.getProtocol()) {
            case CBOR: 
            case ION: 
            case AWS_JSON: {
                return Protocol.AWS_JSON.name();
            }
        }
        return this.metadata.getProtocol().name();
    }
}

