/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.paginators.PaginatorResponseClassSpec;
import software.amazon.awssdk.utils.FunctionalUtils;

public class PaginatorsGeneratorTasks
extends BaseGeneratorTasks {
    private final String paginatorsClassDir;

    public PaginatorsGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.paginatorsClassDir = dependencies.getPathProvider().getPaginatorsDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return this.model.hasPaginators();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting paginator classes");
        return this.model.getPaginators().entrySet().stream().filter(entry -> ((PaginatorDefinition)entry.getValue()).isValid()).map(FunctionalUtils.safeFunction(this::createTask)).collect(Collectors.toList());
    }

    private GeneratorTask createTask(Map.Entry<String, PaginatorDefinition> entry) throws IOException {
        PaginatorResponseClassSpec classSpec = new PaginatorResponseClassSpec(this.model, entry.getKey(), entry.getValue());
        return new PoetGeneratorTask(this.paginatorsClassDir, this.model.getFileHeader(), classSpec);
    }
}

