/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.MemberSetters;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

abstract class AbstractMemberSetters
implements MemberSetters {
    protected final PoetExtensions poetExtensions;
    private final ShapeModel shapeModel;
    private final MemberModel memberModel;
    private final IntermediateModel intermediateModel;
    private final TypeProvider typeProvider;
    private final ServiceModelCopiers serviceModelCopiers;

    AbstractMemberSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        this.shapeModel = shapeModel;
        this.memberModel = memberModel;
        this.intermediateModel = intermediateModel;
        this.typeProvider = typeProvider;
        this.serviceModelCopiers = new ServiceModelCopiers(intermediateModel);
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    protected MethodSpec.Builder fluentAbstractSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.ABSTRACT});
    }

    protected MethodSpec.Builder fluentDefaultSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.DEFAULT});
    }

    protected MethodSpec.Builder fluentSetterBuilder(TypeName returnType) {
        return this.fluentSetterBuilder(this.memberAsParameter(), returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(ParameterSpec setterParam, TypeName returnType) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addParameter(setterParam).addAnnotation(Override.class).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected MethodSpec.Builder beanStyleSetterBuilder() {
        return this.beanStyleSetterBuilder(this.memberAsBeanStyleParameter());
    }

    protected MethodSpec.Builder beanStyleSetterBuilder(ParameterSpec setterParam) {
        return MethodSpec.methodBuilder((String)this.memberModel().getBeanStyleSetterMethodName()).addParameter(setterParam).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected CodeBlock copySetterBody() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.copyMethodName());
    }

    protected CodeBlock copySetterBuilderBody() {
        if (this.memberModel.hasBuilder()) {
            return this.copySetterBody("this.$1N = $1N != null ? $2T.$3N($1N.build()) : null", "this.$1N = $1N != null ? $1N.build() : null", this.serviceModelCopiers.copyMethodName());
        }
        if (this.memberModel.isCollectionWithBuilderMember()) {
            return this.copySetterBody("this.$1N = $2T.$3N($1N)", null, this.serviceModelCopiers.builderCopyMethodName());
        }
        return this.copySetterBody();
    }

    protected ParameterSpec memberAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.parameterType(this.memberModel), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    protected ParameterSpec memberAsBeanStyleParameter() {
        if (this.memberModel.hasBuilder()) {
            ClassName builderName = this.poetExtensions.getModelClass(this.memberModel.getC2jShape()).nestedClass("BuilderImpl");
            return ParameterSpec.builder((TypeName)builderName, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
        }
        if (this.memberModel.isList() && this.hasBuilder(this.memberModel.getListModel().getListMemberModel())) {
            ClassName memberName = this.poetExtensions.getModelClass(this.memberModel.getListModel().getListMemberModel().getC2jShape()).nestedClass("BuilderImpl");
            ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{memberName});
            return ParameterSpec.builder((TypeName)listType, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
        }
        if (this.memberModel.isMap() && this.hasBuilder(this.memberModel.getMapModel().getValueModel())) {
            TypeName keyType = this.typeProvider.getTypeNameForSimpleType(this.memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
            ClassName valueType = this.poetExtensions.getModelClass(this.memberModel.getMapModel().getValueModel().getC2jShape()).nestedClass("BuilderImpl");
            ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
            return ParameterSpec.builder((TypeName)mapType, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
        }
        return this.memberAsParameter();
    }

    protected ShapeModel shapeModel() {
        return this.shapeModel;
    }

    protected MemberModel memberModel() {
        return this.memberModel;
    }

    protected String fieldName() {
        return this.memberModel.getVariable().getVariableName();
    }

    protected boolean annotateJsonProperty() {
        return this.intermediateModel.getMetadata().isJsonProtocol() && this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private MethodSpec.Builder fluentSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).returns(returnType);
    }

    private CodeBlock copySetterBody(String copyAssignment, String regularAssignment, String copyMethodName) {
        Optional<ClassName> copierClass = this.serviceModelCopiers.copierClassFor(this.memberModel);
        return copierClass.map(className -> CodeBlock.builder().addStatement(copyAssignment, new Object[]{this.fieldName(), className, copyMethodName}).build()).orElseGet(() -> CodeBlock.builder().addStatement(regularAssignment, new Object[]{this.fieldName()}).build());
    }

    private boolean hasBuilder(MemberModel model) {
        return model != null && model.hasBuilder();
    }
}

