/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.config.templates;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.codegen.internal.ClassLoaderHelper;
import software.amazon.awssdk.codegen.internal.Jackson;
import software.amazon.awssdk.codegen.model.config.templates.ChildTemplate;
import software.amazon.awssdk.codegen.model.config.templates.TopLevelTemplate;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;

public class CodeGenTemplatesConfig {
    private TopLevelTemplate syncClientBuilder = new TopLevelTemplate("/templates/common/SyncClientBuilder.ftl", null);
    private TopLevelTemplate asyncClientBuilder = new TopLevelTemplate("/templates/common/AsyncClientBuilder.ftl", null);
    private TopLevelTemplate modelUnmarshaller;
    private TopLevelTemplate modelMarshaller;
    private TopLevelTemplate requestMarshaller;
    private TopLevelTemplate baseExceptionClass;
    private TopLevelTemplate exceptionUnmarshaller;
    private TopLevelTemplate policyActionClass;
    private TopLevelTemplate packageInfo;
    private TopLevelTemplate customRequestSignerClass;
    private TopLevelTemplate cucumberModuleInjector = new TopLevelTemplate("/templates/cucumber/ModuleInjector.ftl", null);
    private TopLevelTemplate cucumberTest = new TopLevelTemplate("/templates/cucumber/RunCucumberTest.ftl", null);
    private TopLevelTemplate cucumberPropertiesFile = new TopLevelTemplate("/templates/cucumber/cucumberProperties.ftl", null);
    private TopLevelTemplate apiGatewayPomTemplate = new TopLevelTemplate("/templates/api-gateway/maven/pom.xml.ftl", null);
    private TopLevelTemplate apiGatewayGradleBuildTemplate = new TopLevelTemplate("/templates/api-gateway/gradle/build.gradle.ftl", null);
    private TopLevelTemplate apiGatewayGradleSettingsTemplate = new TopLevelTemplate("/templates/api-gateway/gradle/settings.gradle.ftl", null);
    private TopLevelTemplate apiGatewayReadmeTemplate = new TopLevelTemplate("/templates/api-gateway/README.md.ftl", Collections.singletonList(new ChildTemplate("/templates/api-gateway/README_Dependencies.ftl", "README_Dependencies")));
    private List<ChildTemplate> commonChildTemplates;

    public static CodeGenTemplatesConfig load(Protocol protocol) {
        String protocolConfigFilePath = String.format("/protocol-config/%s.json", protocol.getValue());
        InputStream input = ClassLoaderHelper.getResourceAsStream(protocolConfigFilePath, CodeGenTemplatesConfig.class);
        if (input == null) {
            input = ClassLoaderHelper.getResourceAsStream("/" + protocolConfigFilePath, CodeGenTemplatesConfig.class);
        }
        try {
            return Jackson.load(CodeGenTemplatesConfig.class, input);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load the protocol specific config file from the location " + protocolConfigFilePath, e);
        }
    }

    public static CodeGenTemplatesConfig merge(CodeGenTemplatesConfig config, CodeGenTemplatesConfig override) {
        CodeGenTemplatesConfig merged = new CodeGenTemplatesConfig();
        merged.setModelUnmarshaller(TopLevelTemplate.merge(config.getModelUnmarshaller(), override.getModelUnmarshaller()));
        merged.setModelMarshaller(TopLevelTemplate.merge(config.getModelMarshaller(), override.getModelMarshaller()));
        merged.setRequestMarshaller(TopLevelTemplate.merge(config.getRequestMarshaller(), override.getRequestMarshaller()));
        merged.setBaseExceptionClass(TopLevelTemplate.merge(config.getBaseExceptionClass(), override.getBaseExceptionClass()));
        merged.setExceptionUnmarshaller(TopLevelTemplate.merge(config.getExceptionUnmarshaller(), override.getExceptionUnmarshaller()));
        merged.setPolicyActionClass(TopLevelTemplate.merge(config.getPolicyActionClass(), override.getPolicyActionClass()));
        merged.setPackageInfo(TopLevelTemplate.merge(config.getPackageInfo(), override.getPackageInfo()));
        merged.setCustomRequestSignerClass(TopLevelTemplate.merge(config.getCustomRequestSignerClass(), override.getCustomRequestSignerClass()));
        LinkedList<ChildTemplate> commonChildTemplates = new LinkedList<ChildTemplate>();
        if (config.getCommonChildTemplates() != null) {
            commonChildTemplates.addAll(config.getCommonChildTemplates());
        }
        if (override.getCommonChildTemplates() != null) {
            commonChildTemplates.addAll(override.getCommonChildTemplates());
        }
        merged.setCommonChildTemplates(commonChildTemplates);
        return merged;
    }

    public TopLevelTemplate getSyncClientBuilder() {
        return this.syncClientBuilder;
    }

    public void setSyncClientBuilder(TopLevelTemplate syncClientBuilder) {
        this.syncClientBuilder = syncClientBuilder;
    }

    public TopLevelTemplate getAsyncClientBuilder() {
        return this.asyncClientBuilder;
    }

    public void setAsyncClientBuilder(TopLevelTemplate syncClientBuilder) {
        this.asyncClientBuilder = syncClientBuilder;
    }

    public TopLevelTemplate getModelUnmarshaller() {
        return this.modelUnmarshaller;
    }

    public void setModelUnmarshaller(TopLevelTemplate modelUnmarshaller) {
        this.modelUnmarshaller = modelUnmarshaller;
    }

    public TopLevelTemplate getModelMarshaller() {
        return this.modelMarshaller;
    }

    public TopLevelTemplate getRequestMarshaller() {
        return this.requestMarshaller;
    }

    public void setModelMarshaller(TopLevelTemplate modelMarshaller) {
        this.modelMarshaller = modelMarshaller;
    }

    public void setRequestMarshaller(TopLevelTemplate requestMarshaller) {
        this.requestMarshaller = requestMarshaller;
    }

    public TopLevelTemplate getExceptionUnmarshaller() {
        return this.exceptionUnmarshaller;
    }

    public void setExceptionUnmarshaller(TopLevelTemplate exceptionUnmarshaller) {
        this.exceptionUnmarshaller = exceptionUnmarshaller;
    }

    public List<ChildTemplate> getCommonChildTemplates() {
        return this.commonChildTemplates;
    }

    public void setCommonChildTemplates(List<ChildTemplate> commonChildTemplates) {
        this.commonChildTemplates = commonChildTemplates;
    }

    public TopLevelTemplate getPolicyActionClass() {
        return this.policyActionClass;
    }

    public void setPolicyActionClass(TopLevelTemplate policyActionClass) {
        this.policyActionClass = policyActionClass;
    }

    public TopLevelTemplate getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(TopLevelTemplate packageInfo) {
        this.packageInfo = packageInfo;
    }

    public TopLevelTemplate getBaseExceptionClass() {
        return this.baseExceptionClass;
    }

    public void setBaseExceptionClass(TopLevelTemplate baseExceptionClass) {
        this.baseExceptionClass = baseExceptionClass;
    }

    public TopLevelTemplate getCucumberModuleInjector() {
        return this.cucumberModuleInjector;
    }

    public TopLevelTemplate getCucumberTest() {
        return this.cucumberTest;
    }

    public TopLevelTemplate getCucumberPropertiesFile() {
        return this.cucumberPropertiesFile;
    }

    public TopLevelTemplate getCustomRequestSignerClass() {
        return this.customRequestSignerClass;
    }

    public void setCustomRequestSignerClass(TopLevelTemplate customRequestSignerClass) {
        this.customRequestSignerClass = customRequestSignerClass;
    }

    public TopLevelTemplate getApiGatewayPomTemplate() {
        return this.apiGatewayPomTemplate;
    }

    public TopLevelTemplate getApiGatewayGradleBuildTemplate() {
        return this.apiGatewayGradleBuildTemplate;
    }

    public TopLevelTemplate getApiGatewayGradleSettingsTemplate() {
        return this.apiGatewayGradleSettingsTemplate;
    }

    public TopLevelTemplate getApiGatewayReadmeTemplate() {
        return this.apiGatewayReadmeTemplate;
    }
}

