/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.internal.Freemarker;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;

public abstract class BaseGeneratorTasks
implements Iterable<GeneratorTask> {
    protected final String baseDirectory;
    protected final String testDirectory;
    protected final IntermediateModel model;
    protected final Freemarker freemarker;
    protected final Logger log;

    public BaseGeneratorTasks(GeneratorTaskParams dependencies) {
        this.baseDirectory = dependencies.getPathProvider().getSourceDirectory();
        this.testDirectory = dependencies.getPathProvider().getTestDirectory();
        this.model = dependencies.getModel();
        this.freemarker = dependencies.getFreemarker();
        this.log = dependencies.getLog();
    }

    protected void info(String message) {
        this.log.info(message);
    }

    protected boolean hasTasks() {
        return true;
    }

    protected final GeneratorTask createPoetGeneratorTask(ClassSpec classSpec) throws IOException {
        String targetDirectory = this.baseDirectory + '/' + Utils.packageToDirectory(classSpec.className().packageName());
        return new PoetGeneratorTask(targetDirectory, this.model.getFileHeader(), classSpec);
    }

    protected final GeneratorTask createPoetGeneratorTestTask(ClassSpec classSpec) throws IOException {
        String targetDirectory = this.testDirectory + '/' + Utils.packageToDirectory(classSpec.className().packageName());
        return new PoetGeneratorTask(targetDirectory, this.model.getFileHeader(), classSpec);
    }

    protected abstract List<GeneratorTask> createTasks() throws Exception;

    @Override
    public Iterator<GeneratorTask> iterator() {
        try {
            if (this.hasTasks()) {
                return this.createTasks().iterator();
            }
            return Collections.emptyList().iterator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

