/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;

public class PaginationDocs {
    private final OperationModel operationModel;
    private final PoetExtensions poetExtensions;

    public PaginationDocs(IntermediateModel intermediateModel, OperationModel operationModel) {
        this.operationModel = operationModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    public String getDocsForSyncOperation() {
        return CodeBlock.builder().add("<p>This is a variant of {@link #$L($T)} operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle making service calls for you.\n</p>", new Object[]{this.operationModel.getMethodName(), this.requestType()}).add("<p>\nWhen this operation is called, a custom iterable is returned but no service calls are made yet. So there is no guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response pages by making service calls until there are no pages left or your iteration stops. If there are errors in your request, you will see the failures only after you start iterating through the iterable.\n</p>", new Object[0]).add(this.getSyncCodeSnippets(), new Object[0]).build().toString();
    }

    public String getDocsForSyncResponseClass(ClassName clientInterface) {
        return CodeBlock.builder().add("<p>Represents the output for the {@link $T#$L($T)} operation which is a paginated operation. This class is an iterable of {@link $T} that can be used to iterate through all the response pages of the operation.</p>", new Object[]{clientInterface, this.getSyncPaginatedMethodName(), this.requestType(), this.syncResponsePageType()}).add("<p>When the operation is called, an instance of this class is returned.  At this point, no service calls are made yet and so there is no guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response pages by making service calls until there are no pages left or your iteration stops. If there are errors in your request, you will see the failures only after you start iterating through the iterable.</p>", new Object[0]).add(this.getSyncCodeSnippets(), new Object[0]).build().toString();
    }

    private String getSyncCodeSnippets() {
        CodeBlock callOperationOnClient = CodeBlock.builder().addStatement("$T responses = client.$L(request)", new Object[]{this.syncPaginatedResponseType(), this.getSyncPaginatedMethodName()}).build();
        return CodeBlock.builder().add("\n\n<p>The following are few ways to iterate through the response pages:</p>", new Object[0]).add("1) Using a Stream", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).addStatement("responses.stream().forEach(....)", new Object[0]).build())).add("\n\n2) Using For loop", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).beginControlFlow("for ($T response : responses)", new Object[]{this.syncResponsePageType()}).addStatement(" // do something", new Object[0]).endControlFlow().build())).add("\n\n3) Use iterator directly", new Object[0]).add(this.buildCode(CodeBlock.builder().add(callOperationOnClient).addStatement("responses.iterator().forEachRemaining(....)", new Object[0]).build())).add(this.noteAboutSyncNonPaginatedMethod()).build().toString();
    }

    private CodeBlock buildCode(CodeBlock codeSnippet) {
        return CodeBlock.builder().add("<pre>{@code\n", new Object[0]).add(codeSnippet).add("}</pre>", new Object[0]).build();
    }

    private String getSyncPaginatedMethodName() {
        return PaginatorUtils.getSyncMethodName(this.operationModel.getMethodName());
    }

    private ClassName requestType() {
        return this.poetExtensions.getModelClass(this.operationModel.getInput().getVariableType());
    }

    private ClassName syncResponsePageType() {
        return this.poetExtensions.getModelClass(this.operationModel.getReturnType().getReturnType());
    }

    public ClassName syncPaginatedResponseType() {
        return this.poetExtensions.getResponseClassForPaginatedSyncOperation(this.operationModel.getOperationName());
    }

    private CodeBlock noteAboutSyncNonPaginatedMethod() {
        return CodeBlock.builder().add("\n<p><b>Note: If you prefer to have control on service calls, use the {@link #$L($T)} operation.</b></p>", new Object[]{this.operationModel.getMethodName(), this.requestType()}).build();
    }
}

