/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.PaginationDocs;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

abstract class OperationDocProvider {
    static final String SIMPLE_FILE_INPUT_DOCS = "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. ";
    static final String SIMPLE_FILE_OUTPUT_DOCS = "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. ";
    protected final IntermediateModel model;
    protected final OperationModel opModel;
    protected final PaginationDocs paginationDocs;

    OperationDocProvider(IntermediateModel model, OperationModel opModel) {
        this.model = model;
        this.opModel = opModel;
        this.paginationDocs = new PaginationDocs(model, opModel);
    }

    String getDocs() {
        DocumentationBuilder docBuilder = new DocumentationBuilder();
        String description = StringUtils.isNotBlank((CharSequence)this.opModel.getDocumentation()) ? this.opModel.getDocumentation() : this.getDefaultServiceDocs();
        String appendedDescription = this.appendToDescription();
        docBuilder.description(StringUtils.isNotBlank((CharSequence)appendedDescription) ? description + "<br/>" + appendedDescription : description);
        this.applyParams(docBuilder);
        this.applyReturns(docBuilder);
        this.applyThrows(docBuilder);
        docBuilder.tag("sample", this.getInterfaceName() + "." + this.opModel.getOperationName());
        String crosslink = DocumentationUtils.createLinkToServiceDocumentation(this.model.getMetadata(), this.opModel.getOperationName());
        if (!crosslink.isEmpty()) {
            docBuilder.see(crosslink);
        }
        return docBuilder.build().replace("$", "&#36");
    }

    protected String appendToDescription() {
        return "";
    }

    final String getStreamingInputDocs() {
        return String.format("The service documentation for the request content is as follows '%s'", this.getStreamingMemberDocs(this.opModel.getInputShape()));
    }

    final String getStreamingOutputDocs() {
        return String.format("The service documentation for the response content is as follows '%s'.", this.getStreamingMemberDocs(this.opModel.getOutputShape()));
    }

    private String getStreamingMemberDocs(ShapeModel streamingShape) {
        return streamingShape.getMembers().stream().filter(m -> m.getHttp().getIsStreaming()).map(DocumentationModel::getDocumentation).findFirst().orElseThrow(() -> new IllegalStateException("Streaming member not found in " + streamingShape.getShapeName()));
    }

    final List<Pair<String, String>> getThrows() {
        List<Pair<String, String>> throwsDocs = this.opModel.getExceptions().stream().map(exception -> Pair.of((Object)exception.getExceptionName(), (Object)DocumentationUtils.stripHtmlTags(exception.getDocumentation()))).collect(Collectors.toList());
        String baseServiceException = this.model.getMetadata().getBaseExceptionName();
        Collections.addAll(throwsDocs, Pair.of((Object)"SdkException ", (Object)"Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios."), Pair.of((Object)"SdkClientException ", (Object)"If any client side error occurs such as an IO related failure, failure to get credentials, etc."), Pair.of((Object)baseServiceException, (Object)"Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type."));
        return throwsDocs;
    }

    final void emitRequestParm(DocumentationBuilder docBuilder) {
        docBuilder.param(this.opModel.getInput().getVariableName(), DocumentationUtils.stripHtmlTags(this.opModel.getInput().getDocumentation()));
    }

    protected abstract String getInterfaceName();

    protected abstract String getDefaultServiceDocs();

    protected abstract void applyParams(DocumentationBuilder var1);

    protected abstract void applyReturns(DocumentationBuilder var1);

    protected abstract void applyThrows(DocumentationBuilder var1);
}

