/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.paginators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.docs.PaginationDocs;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;

public class PaginatorResponseClassSpec
implements ClassSpec {
    private static final Logger log = LoggerFactory.getLogger(PaginatorResponseClassSpec.class);
    private static final String CLIENT_MEMBER = "client";
    private static final String REQUEST_MEMBER = "firstRequest";
    private static final String NEXT_PAGE_FETCHER_MEMBER = "nextPageFetcher";
    private static final String HAS_NEXT_PAGE_METHOD = "hasNextPage";
    private static final String NEXT_PAGE_METHOD = "nextPage";
    private static final String PREVIOUS_PAGE_METHOD_ARGUMENT = "previousPage";
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;
    private final String c2jOperationName;
    private final PaginatorDefinition paginatorDefinition;
    private final OperationModel operationModel;
    private final PaginationDocs paginationDocs;

    public PaginatorResponseClassSpec(IntermediateModel intermediateModel, String c2jOperationName, PaginatorDefinition paginatorDefinition) {
        this.model = intermediateModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.c2jOperationName = c2jOperationName;
        this.paginatorDefinition = paginatorDefinition;
        this.operationModel = this.model.getOperation(c2jOperationName);
        this.paginationDocs = new PaginationDocs(intermediateModel, this.operationModel);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(PoetUtils.GENERATED).addSuperinterface(this.getPaginatedResponseInterface()).addFields((Iterable)Stream.of(this.syncClientInterfaceField(), this.requestClassField(), this.nextPageSupplierField()).collect(Collectors.toList())).addMethod(this.constructor()).addMethod(this.iteratorMethod()).addMethods(this.getMethodSpecsForResultKeyList()).addJavadoc(this.paginationDocs.getDocsForSyncResponseClass(this.getClientInterfaceName()), new Object[0]).addType(this.nextPageFetcherClass());
        return specBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getResponseClassForPaginatedSyncOperation(this.c2jOperationName);
    }

    private TypeName getPaginatedResponseInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SdkIterable.class), (TypeName[])new TypeName[]{this.responseType()});
    }

    private ClassName requestType() {
        return this.poetExtensions.getModelClass(this.operationModel.getInput().getVariableType());
    }

    private ClassName responseType() {
        return this.poetExtensions.getModelClass(this.operationModel.getReturnType().getReturnType());
    }

    private ClassName getClientInterfaceName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
    }

    private FieldSpec syncClientInterfaceField() {
        return FieldSpec.builder((TypeName)this.getClientInterfaceName(), (String)CLIENT_MEMBER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec requestClassField() {
        return FieldSpec.builder((TypeName)this.requestType(), (String)REQUEST_MEMBER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec nextPageSupplierField() {
        return FieldSpec.builder(NextPageFetcher.class, (String)NEXT_PAGE_FETCHER_MEMBER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private String nextPageFetcherClassName() {
        return this.operationModel.getReturnType().getReturnType() + "Fetcher";
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.getClientInterfaceName(), CLIENT_MEMBER, new Modifier[]{Modifier.FINAL}).addParameter((TypeName)this.requestType(), REQUEST_MEMBER, new Modifier[]{Modifier.FINAL}).addStatement("this.$L = $L", new Object[]{CLIENT_MEMBER, CLIENT_MEMBER}).addStatement("this.$L = $L", new Object[]{REQUEST_MEMBER, REQUEST_MEMBER}).addStatement("this.$L = new $L()", new Object[]{NEXT_PAGE_FETCHER_MEMBER, this.nextPageFetcherClassName()}).build();
    }

    private MethodSpec iteratorMethod() {
        return MethodSpec.methodBuilder((String)"iterator").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{this.responseType()})).addStatement("return new $T($L)", new Object[]{PaginatedResponsesIterator.class, NEXT_PAGE_FETCHER_MEMBER}).build();
    }

    private Iterable<MethodSpec> getMethodSpecsForResultKeyList() {
        if (this.paginatorDefinition.getResultKey() != null) {
            return this.paginatorDefinition.getResultKey().stream().map(this::getMethodsSpecForSingleResultKey).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private MethodSpec getMethodsSpecForSingleResultKey(String resultKey) {
        TypeName resultKeyType = this.getTypeForResultKey(resultKey);
        MemberModel resultKeyModel = this.memberModelForResponseMember(resultKey);
        return MethodSpec.methodBuilder((String)resultKeyModel.getFluentGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SdkIterable.class), (TypeName[])new TypeName[]{resultKeyType})).addCode("$T getIterator = ", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.responseType(), ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{resultKeyType})})}).addCode(this.getPaginatedMemberIteratorLambdaBlock(resultKey, resultKeyModel)).addCode("\n", new Object[0]).addStatement("return new $T(this, getIterator)", new Object[]{PaginatedItemsIterable.class}).addJavadoc(CodeBlock.builder().add("Returns an iterable to iterate through the paginated {@link $T#$L()} member. The returned iterable is used to iterate through the results across all response pages and not a single page.\n", new Object[]{this.responseType(), resultKeyModel.getFluentGetterMethodName()}).add("\n", new Object[0]).add("This method is useful if you are interested in iterating over the paginated member in the response pages instead of the top level pages. Similar to iteration over pages, this method internally makes service calls to get the next list of results until the iteration stops or there are no more results.", new Object[0]).build()).build();
    }

    private CodeBlock getPaginatedMemberIteratorLambdaBlock(String resultKey, MemberModel resultKeyModel) {
        String response = "response";
        String fluentGetter = this.fluentGetterMethodForResponseMember(resultKey);
        CodeBlock iteratorBlock = null;
        if (resultKeyModel.isList()) {
            iteratorBlock = CodeBlock.builder().add("$L.$L.iterator()", new Object[]{"response", fluentGetter}).build();
        } else if (resultKeyModel.isMap()) {
            iteratorBlock = CodeBlock.builder().add("$L.$L.entrySet().iterator()", new Object[]{"response", fluentGetter}).build();
        }
        return CodeBlock.builder().addStatement("$L -> $L != null ? $L : null", new Object[]{"response", "response", iteratorBlock}).build();
    }

    private List<String> fluentSetterMethodNamesForInputToken() {
        return this.paginatorDefinition.getInputToken().stream().map(this::fluentSetterNameForSingleInputToken).collect(Collectors.toList());
    }

    private String fluentSetterNameForSingleInputToken(String inputToken) {
        return this.operationModel.getInputShape().findMemberModelByC2jName(inputToken).getFluentSetterMethodName();
    }

    private List<String> fluentGetterMethodsForOutputToken() {
        return this.paginatorDefinition.getOutputToken().stream().map(this::fluentGetterMethodForResponseMember).collect(Collectors.toList());
    }

    private String fluentGetterMethodForResponseMember(String member) {
        String[] hierarchy = member.split("\\.");
        if (hierarchy.length < 1) {
            throw new IllegalArgumentException(String.format("Error when splitting member %s for operation %s", member, this.c2jOperationName));
        }
        ShapeModel parentShape = this.operationModel.getOutputShape();
        StringBuilder getterMethod = new StringBuilder();
        for (String str : hierarchy) {
            getterMethod.append(".").append(parentShape.findMemberModelByC2jName(str).getFluentGetterMethodName()).append("()");
            parentShape = parentShape.findMemberModelByC2jName(str).getShape();
        }
        return getterMethod.substring(1);
    }

    private MemberModel memberModelForResponseMember(String input) {
        String[] hierarchy = input.split("\\.");
        if (hierarchy.length < 1) {
            throw new IllegalArgumentException(String.format("Error when splitting value %s for operation %s", input, this.c2jOperationName));
        }
        ShapeModel shape = this.operationModel.getOutputShape();
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            shape = shape.findMemberModelByC2jName(hierarchy[i]).getShape();
        }
        return shape.getMemberByC2jName(hierarchy[hierarchy.length - 1]);
    }

    private TypeName getTypeForResultKey(String singleResultKey) {
        MemberModel resultKeyModel = this.memberModelForResponseMember(singleResultKey);
        if (resultKeyModel == null) {
            throw new InvalidParameterException("MemberModel is not found for result key: " + singleResultKey);
        }
        if (resultKeyModel.isList()) {
            return this.typeProvider.fieldType(resultKeyModel.getListModel().getListMemberModel());
        }
        if (resultKeyModel.isMap()) {
            return this.typeProvider.mapEntryWithConcreteTypes(resultKeyModel.getMapModel());
        }
        throw new IllegalArgumentException(String.format("Key %s in paginated operation %s should be either a list or a map", singleResultKey, this.c2jOperationName));
    }

    private TypeSpec nextPageFetcherClass() {
        return TypeSpec.classBuilder((String)this.nextPageFetcherClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(NextPageFetcher.class), (TypeName[])new TypeName[]{this.responseType()})).addMethod(MethodSpec.methodBuilder((String)HAS_NEXT_PAGE_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), PREVIOUS_PAGE_METHOD_ARGUMENT, new Modifier[0]).returns(Boolean.TYPE).addStatement(this.hasNextPageMethodBody(), new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)NEXT_PAGE_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), PREVIOUS_PAGE_METHOD_ARGUMENT, new Modifier[0]).returns((TypeName)this.responseType()).addCode(this.nextPageMethodBody()).build()).build();
    }

    private String hasNextPageMethodBody() {
        String body = this.paginatorDefinition.getMoreResults() != null ? String.format("return %s.%s.booleanValue()", PREVIOUS_PAGE_METHOD_ARGUMENT, this.fluentGetterMethodForResponseMember(this.paginatorDefinition.getMoreResults())) : String.format("return %s.%s != null", PREVIOUS_PAGE_METHOD_ARGUMENT, this.fluentGetterMethodsForOutputToken().get(0));
        return body;
    }

    private CodeBlock nextPageMethodBody() {
        return CodeBlock.builder().beginControlFlow("if ($L == null)", new Object[]{PREVIOUS_PAGE_METHOD_ARGUMENT}).addStatement("return $L.$L($L)", new Object[]{CLIENT_MEMBER, this.operationModel.getMethodName(), REQUEST_MEMBER}).endControlFlow().addStatement(this.codeToGetNextPageIfOldResponseIsNotNull(), new Object[0]).build();
    }

    private String codeToGetNextPageIfOldResponseIsNotNull() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("return %s.%s(%s.toBuilder()", CLIENT_MEMBER, this.operationModel.getMethodName(), REQUEST_MEMBER));
        List<String> requestSetterNames = this.fluentSetterMethodNamesForInputToken();
        List<String> responseGetterMethods = this.fluentGetterMethodsForOutputToken();
        for (int i = 0; i < this.paginatorDefinition.getInputToken().size(); ++i) {
            sb.append(String.format(".%s(%s.%s)", requestSetterNames.get(i), PREVIOUS_PAGE_METHOD_ARGUMENT, responseGetterMethods.get(i)));
        }
        sb.append(".build())");
        return sb.toString();
    }
}

