/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import software.amazon.awssdk.codegen.model.config.BasicCodeGenConfig;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Waiters;

public class C2jModels {
    private final ServiceModel serviceModel;
    private final Waiters waitersModel;
    private final ServiceExamples examplesModel;
    private final BasicCodeGenConfig codeGenConfig;
    private final CustomizationConfig customizationConfig;

    private C2jModels(ServiceModel serviceModel, Waiters waitersModel, ServiceExamples examplesModel, BasicCodeGenConfig codeGenConfig, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.waitersModel = waitersModel;
        this.examplesModel = examplesModel;
        this.codeGenConfig = codeGenConfig;
        this.customizationConfig = customizationConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceModel serviceModel() {
        return this.serviceModel;
    }

    public Waiters waitersModel() {
        return this.waitersModel;
    }

    public ServiceExamples examplesModel() {
        return this.examplesModel;
    }

    public BasicCodeGenConfig codeGenConfig() {
        return this.codeGenConfig;
    }

    public CustomizationConfig customizationConfig() {
        return this.customizationConfig;
    }

    public static class Builder {
        private ServiceModel serviceModel;
        private Waiters waitersModel;
        private ServiceExamples examplesModel;
        private BasicCodeGenConfig codeGenConfig;
        private CustomizationConfig customizationConfig;

        private Builder() {
        }

        public Builder serviceModel(ServiceModel serviceModel) {
            this.serviceModel = serviceModel;
            return this;
        }

        public Builder waitersModel(Waiters waitersModel) {
            this.waitersModel = waitersModel;
            return this;
        }

        public Builder examplesModel(ServiceExamples examplesModel) {
            this.examplesModel = examplesModel;
            return this;
        }

        public Builder codeGenConfig(BasicCodeGenConfig codeGenConfig) {
            this.codeGenConfig = codeGenConfig;
            return this;
        }

        public Builder customizationConfig(CustomizationConfig customizationConfig) {
            this.customizationConfig = customizationConfig;
            return this;
        }

        public C2jModels build() {
            Waiters waiters = this.waitersModel != null ? this.waitersModel : Waiters.NONE;
            ServiceExamples examples = this.examplesModel != null ? this.examplesModel : ServiceExamples.NONE;
            return new C2jModels(this.serviceModel, waiters, examples, this.codeGenConfig, this.customizationConfig);
        }
    }
}

