/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.BasicCodeGenConfig;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceMetadata;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

final class AddMetadata {
    private static final String AWS_PACKAGE_PREFIX = "software.amazon.awssdk.services";

    private AddMetadata() {
    }

    public static Metadata constructMetadata(ServiceModel serviceModel, BasicCodeGenConfig codeGenConfig, CustomizationConfig customizationConfig) {
        String rootPackageName;
        String serviceName;
        Metadata metadata = new Metadata();
        ServiceMetadata serviceMetadata = serviceModel.getMetadata();
        if (serviceMetadata.getProtocol().equals(Protocol.API_GATEWAY.getValue())) {
            serviceName = codeGenConfig.getInterfaceName();
            rootPackageName = codeGenConfig.getPackageName();
            metadata.withDefaultEndpoint(codeGenConfig.getEndpoint()).withDefaultEndpointWithoutHttpProtocol(Utils.getDefaultEndpointWithoutHttpProtocol(codeGenConfig.getEndpoint())).withDefaultRegion(codeGenConfig.getDefaultRegion());
        } else {
            serviceName = Utils.getServiceName(serviceMetadata, customizationConfig);
            rootPackageName = AWS_PACKAGE_PREFIX;
        }
        metadata.withApiVersion(serviceMetadata.getApiVersion()).withAsyncClient(String.format("Default%sAsyncClient", serviceName)).withAsyncInterface(String.format("%sAsyncClient", serviceName)).withAsyncBuilder(String.format("Default%sAsyncClientBuilder", serviceName)).withAsyncBuilderInterface(String.format("%sAsyncClientBuilder", serviceName)).withBaseBuilderInterface(String.format("%sBaseClientBuilder", serviceName)).withBaseBuilder(String.format("Default%sBaseClientBuilder", serviceName)).withDocumentation(serviceModel.getDocumentation()).withRootPackageName(rootPackageName).withClientPackageName(Utils.getClientPackageName(serviceName, customizationConfig)).withModelPackageName(Utils.getModelPackageName(serviceName, customizationConfig)).withTransformPackageName(Utils.getTransformPackageName(serviceName, customizationConfig)).withRequestTransformPackageName(Utils.getRequestTransformPackageName(serviceName, customizationConfig)).withSmokeTestsPackageName(Utils.getSmokeTestPackageName(serviceName, customizationConfig)).withServiceAbbreviation(serviceMetadata.getServiceAbbreviation()).withServiceFullName(serviceMetadata.getServiceFullName()).withSyncClient(String.format("Default%sClient", serviceName)).withSyncInterface(String.format("%sClient", serviceName)).withSyncBuilder(String.format("Default%sClientBuilder", serviceName)).withSyncBuilderInterface(String.format("%sClientBuilder", serviceName)).withBaseExceptionName(String.format("%sException", serviceName)).withProtocol(Protocol.fromValue(serviceMetadata.getProtocol())).withJsonVersion(serviceMetadata.getJsonVersion()).withEndpointPrefix(serviceMetadata.getEndpointPrefix()).withSigningName(serviceMetadata.getSigningName()).withAuthType(AuthType.fromValue(serviceMetadata.getSignatureVersion())).withRequiresApiKey(AddMetadata.requiresApiKey(serviceModel)).withUid(serviceMetadata.getUid());
        String jsonVersion = AddMetadata.getJsonVersion(metadata, serviceMetadata);
        metadata.setJsonVersion(jsonVersion);
        metadata.setHasApiWithStreamInput(false);
        return metadata;
    }

    private static String getJsonVersion(Metadata metadata, ServiceMetadata serviceMetadata) {
        if (serviceMetadata.getJsonVersion() == null && metadata.isJsonProtocol()) {
            return "1.1";
        }
        return serviceMetadata.getJsonVersion();
    }

    private static boolean requiresApiKey(ServiceModel serviceModel) {
        return serviceModel.getOperations().values().stream().anyMatch(Operation::requiresApiKey);
    }
}

