/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.presign.PresignerParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.Ec2ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.QueryXmlProtocolSpec;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ClientConfiguration;
import software.amazon.awssdk.config.SyncClientConfiguration;

public class SyncClientClass
implements ClassSpec {
    private final IntermediateModel model;
    private final String basePackage;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;

    public SyncClientClass(GeneratorTaskParams taskParams) {
        this.model = taskParams.getModel();
        this.basePackage = this.model.getMetadata().getFullClientPackageName();
        this.poetExtensions = taskParams.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model.getMetadata().getProtocol());
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addField(ClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(ClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethods(this.operations());
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            classBuilder.addMethod(this.constructorWithAdvancedConfiguration());
        } else {
            classBuilder.addMethod(this.constructor());
        }
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        classBuilder.addMethod(this.protocolSpec.initProtocolFactory(this.model));
        if (this.model.getHasWaiters()) {
            ClassName waiters = this.poetExtensions.getWaiterClass(this.model.getMetadata().getSyncInterface() + "Waiters");
            classBuilder.addField(FieldSpec.builder((TypeName)waiters, (String)"waiters", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).build());
            classBuilder.addMethod(this.waiters());
        }
        if (this.model.getCustomizationConfig().getPresignersFqcn() != null) {
            classBuilder.addMethod(this.presigners());
        }
        classBuilder.addMethod(this.closeMethod());
        classBuilder.addMethods(this.protocolSpec.additionalMethods());
        return classBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, null)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]).build();
    }

    private MethodSpec constructorWithAdvancedConfiguration() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SyncClientConfiguration.class, "clientConfiguration", new Modifier[0]).addParameter((TypeName)advancedConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration, serviceConfiguration)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]).build();
    }

    private List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::operationMethodSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MethodSpec> operationMethodSpecs(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        methods.add(SyncClientInterface.operationMethodSignature(this.model, opModel).addAnnotation(Override.class).addCode(ClientClassUtils.getCustomResponseHandler(opModel, returnType).orElseGet(() -> this.protocolSpec.responseHandler(opModel))).addCode(this.protocolSpec.errorResponseHandler(opModel)).addCode(this.protocolSpec.executionHandler(opModel)).build());
        return methods;
    }

    private MethodSpec waiters() {
        ClassName waiters = this.poetExtensions.getWaiterClass(this.model.getMetadata().getSyncInterface() + "Waiters");
        return MethodSpec.methodBuilder((String)"waiters").returns((TypeName)waiters).addModifiers(new Modifier[]{Modifier.PUBLIC}).beginControlFlow("if ($N == null)", new Object[]{"waiters"}).beginControlFlow("synchronized(this)", new Object[0]).beginControlFlow("if ($N == null)", new Object[]{"waiters"}).addStatement("waiters = new $T(this)", new Object[]{waiters}).endControlFlow().endControlFlow().endControlFlow().addStatement("return $N", new Object[]{"waiters"}).build();
    }

    private MethodSpec presigners() {
        ClassName presigners = PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getPresignersFqcn());
        return MethodSpec.methodBuilder((String)"presigners").returns((TypeName)presigners).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new $T($T.builder().endpoint(clientConfiguration.endpoint()).credentialsProvider(clientConfiguration.credentialsProvider()).signerProvider(clientConfiguration.overrideConfiguration().advancedOption($T.SIGNER_PROVIDER)).build())", new Object[]{presigners, PresignerParams.class, AdvancedClientOption.class}).build();
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addStatement("clientHandler.close()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    static ProtocolSpec getProtocolSpecs(PoetExtensions poetExtensions, Protocol protocol) {
        switch (protocol) {
            case QUERY: 
            case REST_XML: {
                return new QueryXmlProtocolSpec(poetExtensions);
            }
            case EC2: {
                return new Ec2ProtocolSpec(poetExtensions);
            }
            case AWS_JSON: 
            case REST_JSON: 
            case CBOR: 
            case ION: {
                return new JsonProtocolSpec(poetExtensions);
            }
            case API_GATEWAY: {
                throw new UnsupportedOperationException("Not yet supported.");
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }
}

