/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import software.amazon.awssdk.codegen.protocol.ApiGatewayProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.AwsCborProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.AwsJsonProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.Ec2ProtocolMetdataProvider;
import software.amazon.awssdk.codegen.protocol.IonProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.ProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.QueryProtocolMetadataProvider;
import software.amazon.awssdk.codegen.protocol.RestJsonProtocolMetdataProvider;
import software.amazon.awssdk.codegen.protocol.RestXmlProtocolMetadataProvider;

public enum Protocol {
    EC2("ec2", new Ec2ProtocolMetdataProvider()),
    AWS_JSON("json", new AwsJsonProtocolMetadataProvider()),
    REST_JSON("rest-json", new RestJsonProtocolMetdataProvider()),
    CBOR("cbor", new AwsCborProtocolMetadataProvider()),
    QUERY("query", new QueryProtocolMetadataProvider()),
    REST_XML("rest-xml", new RestXmlProtocolMetadataProvider()),
    API_GATEWAY("api-gateway", new ApiGatewayProtocolMetadataProvider()),
    ION("ion", new IonProtocolMetadataProvider());

    private String protocol;
    private ProtocolMetadataProvider metadataProvider;

    private Protocol(String protocol, ProtocolMetadataProvider metadataProvider) {
        this.protocol = protocol;
        this.metadataProvider = metadataProvider;
    }

    @JsonCreator
    public static Protocol fromValue(String strProtocol) {
        if (strProtocol == null) {
            return null;
        }
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.protocol.equals(strProtocol)) continue;
            return protocol;
        }
        throw new IllegalArgumentException("Unknown enum value for Protocol : " + strProtocol);
    }

    @JsonValue
    public String getValue() {
        return this.protocol;
    }

    public ProtocolMetadataProvider getProvider() {
        return this.metadataProvider;
    }
}

