/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringEscapeUtils;
import software.amazon.awssdk.utils.StringUtils;

public class AcceptorModel {
    private String matcher;
    private String argument;
    private String state;
    private JsonNode expected;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getArgument() {
        String[] unformatted = this.argument.split("\\.");
        StringJoiner formatted = new StringJoiner(".");
        for (String format : unformatted) {
            formatted.add(StringUtils.uncapitalize((String)format));
        }
        return formatted.toString();
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public JsonNode getExpected() {
        return this.expected;
    }

    public void setExpected(JsonNode expected) {
        this.expected = expected;
    }

    public String getExpectedAsCamelCase() {
        return StringUtils.capitalize((String)this.expected.asText().replaceAll("\\W", ""));
    }

    public String getExpectedAsEscapedJson() {
        return StringEscapeUtils.escapeJava((String)this.expected.toString());
    }

    public String getExpectedAsString() {
        if (this.expected.isTextual()) {
            return this.expected.toString();
        }
        return null;
    }

    public BigDecimal getExpectedAsNumber() {
        if (this.expected.isNumber()) {
            return this.expected.decimalValue();
        }
        return null;
    }

    public String getEnumState() {
        return "WaiterState." + StringUtils.upperCase((String)this.state);
    }

    public boolean getIsStatusMatcher() {
        return this.matcher.equals("status");
    }

    public boolean getIsErrorMatcher() {
        return this.matcher.equals("error");
    }
}

