/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.util.ImmutableMapParameter;

public class BaseExceptionClassGeneratorTasks
extends BaseGeneratorTasks {
    private final String modelClassDir;

    public BaseExceptionClassGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.modelClassDir = dependencies.getPathProvider().getModelDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return this.model.getCustomizationConfig().getSdkModeledExceptionBaseClassName() == null;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Base Service Exception class");
        String baseClassName = this.model.getSdkModeledExceptionBaseClassName();
        return Collections.singletonList(new FreemarkerGeneratorTask(this.modelClassDir, baseClassName, this.freemarker.getBaseExceptionClassTemplate(), ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"className", (Object)baseClassName, (Object)"metadata", (Object)this.model.getMetadata(), (Object)"baseExceptionFqcn", (Object)this.model.getServiceBaseExceptionFqcn())));
    }
}

