/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.internal.Constants;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

public final class DocumentationBuilder {
    private static final String ASYNC_THROWS_PREFIX = "The CompletableFuture returned by this method can be completed exceptionally with the following exceptions.";
    private String desc;
    private List<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
    private String returns;
    private List<Pair<String, String>> asyncThrows = new ArrayList<Pair<String, String>>();
    private List<Pair<String, String>> syncThrows = new ArrayList<Pair<String, String>>();
    private List<Pair<String, List<String>>> tags = new ArrayList<Pair<String, List<String>>>();
    private List<String> see = new ArrayList<String>();

    public DocumentationBuilder description(String docs) {
        this.desc = docs;
        return this;
    }

    public DocumentationBuilder param(String paramName, String paramDocs) {
        this.params.add((Pair<String, String>)new Pair((Object)paramName, (Object)paramDocs));
        return this;
    }

    public DocumentationBuilder param(String paramName, String paramDocs, Object ... formatArgs) {
        return this.param(paramName, String.format(paramDocs, formatArgs));
    }

    public DocumentationBuilder returns(String returnsDoc) {
        this.returns = returnsDoc;
        return this;
    }

    public DocumentationBuilder returns(String returnsDoc, Object ... formatArgs) {
        return this.returns(String.format(returnsDoc, formatArgs));
    }

    public DocumentationBuilder asyncThrows(String exceptionClass, String exceptionDoc) {
        return this.asyncThrows(Collections.singletonList(new Pair((Object)exceptionClass, (Object)exceptionDoc)));
    }

    public DocumentationBuilder asyncThrows(Pair<String, String> ... exceptions) {
        return this.asyncThrows(Arrays.asList(exceptions));
    }

    public DocumentationBuilder asyncThrows(List<Pair<String, String>> exceptions) {
        this.asyncThrows.addAll(exceptions);
        return this;
    }

    public DocumentationBuilder syncThrows(String exceptionClass, String exceptionDoc) {
        return this.syncThrows(Collections.singletonList(new Pair((Object)exceptionClass, (Object)exceptionDoc)));
    }

    public DocumentationBuilder syncThrows(Pair<String, String> ... exceptions) {
        return this.syncThrows(Arrays.asList(exceptions));
    }

    public DocumentationBuilder syncThrows(List<Pair<String, String>> exceptions) {
        this.syncThrows.addAll(exceptions);
        return this;
    }

    public DocumentationBuilder tag(String tagName, String ... tagValues) {
        this.tags.add((Pair<String, List<String>>)new Pair((Object)tagName, Arrays.asList(tagValues)));
        return this;
    }

    public DocumentationBuilder see(String seeLink) {
        this.see.add(seeLink);
        return this;
    }

    public DocumentationBuilder see(String seeLink, Object ... formatArgs) {
        return this.see(String.format(seeLink, formatArgs));
    }

    public String build() {
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.desc)) {
            str.append(this.desc).append(Constants.LF).append(Constants.LF);
        }
        this.params.forEach(p -> {
            StringBuilder cfr_ignored_0 = (StringBuilder)p.apply((paramName, paramDoc) -> this.formatParam(str, (String)paramName, (String)paramDoc));
        });
        if (this.hasReturn() || !this.asyncThrows.isEmpty()) {
            str.append("@return ");
            if (this.hasReturn()) {
                str.append(this.returns);
            }
            if (!this.asyncThrows.isEmpty()) {
                if (!this.hasReturn()) {
                    str.append("A CompletableFuture indicating when result will be completed.");
                }
                this.appendAsyncThrows(str);
            }
            str.append(Constants.LF);
        }
        this.syncThrows.forEach(t -> {
            StringBuilder cfr_ignored_0 = (StringBuilder)t.apply((exName, exDoc) -> this.formatThrows(str, (String)exName, (String)exDoc));
        });
        this.tags.forEach(t -> {
            StringBuilder cfr_ignored_0 = (StringBuilder)t.apply((tagName, tagVals) -> this.formatTag(str, (String)tagName, (List<String>)tagVals));
        });
        this.see.forEach(s -> str.append("@see ").append((String)s).append(Constants.LF));
        return str.toString();
    }

    private boolean hasReturn() {
        return StringUtils.isNotBlank((CharSequence)this.returns);
    }

    private void appendAsyncThrows(StringBuilder str) {
        str.append("<br/>").append(Constants.LF).append(this.asyncThrows.stream().map(t -> (String)t.apply((exName, exDocs) -> String.format("<li>%s %s</li>", exName, exDocs))).collect(Collectors.joining(Constants.LF, ASYNC_THROWS_PREFIX + Constants.LF + "<ul>" + Constants.LF, Constants.LF + "</ul>")));
    }

    private StringBuilder formatParam(StringBuilder doc, String paramName, String paramDoc) {
        return doc.append("@param ").append(paramName).append(" ").append(paramDoc).append(Constants.LF);
    }

    private StringBuilder formatThrows(StringBuilder str, String exName, String exDoc) {
        return str.append("@throws ").append(exName).append(" ").append(exDoc).append(Constants.LF);
    }

    private StringBuilder formatTag(StringBuilder str, String tagName, List<String> tagVals) {
        return str.append("@").append(tagName).append(" ").append(tagVals.stream().collect(Collectors.joining(" "))).append(Constants.LF);
    }
}

