/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.codegen.model.intermediate.AcceptorModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.WaiterDefinitionModel;
import software.amazon.awssdk.codegen.model.service.Acceptor;
import software.amazon.awssdk.codegen.model.service.WaiterDefinition;
import software.amazon.awssdk.codegen.model.service.Waiters;

class AddWaiters {
    private final Waiters waiters;
    private final Map<String, OperationModel> operations;

    AddWaiters(Waiters waiters, Map<String, OperationModel> operations) {
        this.waiters = waiters;
        this.operations = operations;
    }

    Map<String, WaiterDefinitionModel> constructWaiters() throws IOException {
        HashMap<String, WaiterDefinitionModel> javaWaiterModels = new HashMap<String, WaiterDefinitionModel>();
        for (Map.Entry<String, WaiterDefinition> entry : this.waiters.getWaiters().entrySet()) {
            String waiterName = entry.getKey();
            WaiterDefinition waiterDefinition = entry.getValue();
            ArrayList<AcceptorModel> acceptors = new ArrayList<AcceptorModel>();
            WaiterDefinitionModel waiterDefinitionModel = new WaiterDefinitionModel();
            waiterDefinitionModel.setDelay(waiterDefinition.getDelay());
            waiterDefinitionModel.setMaxAttempts(waiterDefinition.getMaxAttempts());
            waiterDefinitionModel.setWaiterName(waiterName);
            waiterDefinitionModel.setOperationModel(this.operations.get(waiterDefinition.getOperation()));
            for (Acceptor acceptor : waiterDefinition.getAcceptors()) {
                AcceptorModel acceptorModel = new AcceptorModel();
                acceptorModel.setMatcher(acceptor.getMatcher());
                acceptorModel.setState(acceptor.getState());
                acceptorModel.setExpected(acceptor.getExpected());
                acceptorModel.setArgument(acceptor.getArgument());
                acceptors.add(acceptorModel);
            }
            waiterDefinitionModel.setAcceptors(acceptors);
            javaWaiterModels.put(waiterName, waiterDefinitionModel);
        }
        return javaWaiterModels;
    }
}

