/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.IntermediateModelShapeProcessor;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.ShapeUnmarshaller;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.Output;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.naming.NamingStrategy;

public class AddEmptyOutputShape
implements IntermediateModelShapeProcessor {
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;
    private final NamingStrategy namingStrategy;

    public AddEmptyOutputShape(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.customizationConfig = builder.getCustomConfig();
        this.namingStrategy = builder.getNamingStrategy();
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        if (this.customizationConfig.useModeledOutputShapeNames()) {
            return currentShapes;
        }
        return this.addEmptyOutputShapes(currentOperations);
    }

    private Map<String, ShapeModel> addEmptyOutputShapes(Map<String, OperationModel> currentOperations) {
        Map<String, Operation> operations = this.serviceModel.getOperations();
        HashMap<String, ShapeModel> emptyOutputShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Output output = operation.getOutput();
            if (output != null) continue;
            String outputShape = operationName + "Response";
            OperationModel operationModel = currentOperations.get(operationName);
            operationModel.setReturnType(new ReturnTypeModel(outputShape));
            ShapeModel shape = new ShapeModel(outputShape).withType(ShapeType.Response.getValue());
            shape.setShapeName(outputShape);
            VariableModel outputVariable = new VariableModel(this.namingStrategy.getVariableName(outputShape), outputShape);
            shape.setVariable(outputVariable);
            shape.setUnmarshaller(new ShapeUnmarshaller());
            emptyOutputShapes.put(outputShape, shape);
        }
        return emptyOutputShapes;
    }
}

