/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.AwsShapePublicInterfaceProvider;
import software.amazon.awssdk.codegen.poet.model.ModelBuilderSpecs;
import software.amazon.awssdk.codegen.poet.model.ModelMethodOverrides;
import software.amazon.awssdk.codegen.poet.model.ShapeInterfaceProvider;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;

public class AwsServiceModel
implements ClassSpec {
    private final ShapeModel shapeModel;
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;
    private final ShapeModelSpec shapeModelSpec;
    private final ShapeInterfaceProvider interfaceProvider;
    private final ModelMethodOverrides modelMethodOverrides;
    private final ModelBuilderSpecs modelBuilderSpecs;

    public AwsServiceModel(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.shapeModel = shapeModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.shapeModelSpec = new ShapeModelSpec(this.shapeModel, this.typeProvider, this.poetExtensions);
        this.interfaceProvider = new AwsShapePublicInterfaceProvider(intermediateModel, this.shapeModel);
        this.modelMethodOverrides = new ModelMethodOverrides(this.poetExtensions);
        this.modelBuilderSpecs = new ModelBuilderSpecs(intermediateModel, this.shapeModel, this.shapeModelSpec, this.typeProvider);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((String)this.shapeModel.getShapeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.GENERATED).addSuperinterfaces(this.modelSuperInterfaces()).superclass(this.modelSuperClass()).addMethods(this.modelClassMethods()).addFields(this.shapeModelSpec.fields()).addTypes(this.nestedModelClassTypes());
        if (this.shapeModel.getDocumentation() != null) {
            specBuilder.addJavadoc("$L", new Object[]{this.shapeModel.getDocumentation()});
        }
        return specBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.shapeModelSpec.className();
    }

    private List<TypeName> modelSuperInterfaces() {
        return this.interfaceProvider.interfacesToImplement().stream().sorted(Comparator.comparing(TypeName::toString)).collect(Collectors.toList());
    }

    private TypeName modelSuperClass() {
        return this.interfaceProvider.baseClassToExtend();
    }

    private List<MethodSpec> modelClassMethods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: {
                methodSpecs.add(this.exceptionConstructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.addAll(this.memberGetters());
                break;
            }
            default: {
                methodSpecs.addAll(this.memberGetters());
                methodSpecs.add(this.constructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.add(this.modelMethodOverrides.hashCodeMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.equalsMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.toStringMethod(this.shapeModel));
            }
        }
        if (this.implementStructuredPojoInterface()) {
            methodSpecs.add(this.structuredPojoMarshallMethod(this.shapeModel));
        }
        return methodSpecs;
    }

    private List<MethodSpec> memberGetters() {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> !m.getHttp().getIsStreaming()).map(m -> MethodSpec.methodBuilder((String)m.getFluentGetterMethodName()).addJavadoc("$L", new Object[]{m.getGetterDocumentation()}).returns(this.typeProvider.fieldType((MemberModel)m)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(this.getterStatement((MemberModel)m)).build()).collect(Collectors.toList());
    }

    private CodeBlock getterStatement(MemberModel model) {
        VariableModel modelVariable = model.getVariable();
        if ("java.nio.ByteBuffer".equals(modelVariable.getVariableType())) {
            return CodeBlock.of((String)"return $1N == null ? null : $1N.asReadOnlyBuffer();", (Object[])new Object[]{modelVariable.getVariableName()});
        }
        return CodeBlock.of((String)"return $N;", (Object[])new Object[]{modelVariable.getVariableName()});
    }

    private List<TypeSpec> nestedModelClassTypes() {
        ArrayList<TypeSpec> nestedClasses = new ArrayList<TypeSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: 
            case Model: 
            case Request: 
            case Response: {
                nestedClasses.add(this.modelBuilderSpecs.builderInterface());
                nestedClasses.add(this.modelBuilderSpecs.beanStyleBuilder());
                break;
            }
        }
        return nestedClasses;
    }

    private boolean implementStructuredPojoInterface() {
        return this.interfaceProvider.shouldImplementInterface(StructuredPojo.class);
    }

    private MethodSpec structuredPojoMarshallMethod(ShapeModel shapeModel) {
        return MethodSpec.methodBuilder((String)"marshall").addAnnotation(SdkInternalApi.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProtocolMarshaller.class, "protocolMarshaller", new Modifier[0]).addStatement("$T.getInstance().marshall(this, $N)", new Object[]{this.poetExtensions.getTransformClass(shapeModel.getShapeName() + "Marshaller"), "protocolMarshaller"}).build();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec exceptionConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        ctorBuilder.addStatement("super(builder.message)", new Object[0]);
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec serializableBuilderClass() {
        return MethodSpec.methodBuilder((String)"serializableBuilderClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)this.modelBuilderSpecs.builderInterfaceName())})).addStatement("return $T.class", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }
}

