/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.QueryXmlProtocolSpec;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.VoidStaxUnmarshaller;

public class Ec2ProtocolSpec
extends QueryXmlProtocolSpec {
    private final PoetExtensions poetExtensions;

    public Ec2ProtocolSpec(PoetExtensions poetExtensions) {
        super(poetExtensions);
        this.poetExtensions = poetExtensions;
    }

    @Override
    public List<MethodSpec> additionalMethods() {
        ArrayList<MethodSpec> additionalMethods = new ArrayList<MethodSpec>();
        additionalMethods.add(this.dryRunMethod());
        return additionalMethods;
    }

    private MethodSpec dryRunMethod() {
        TypeVariableName typeVariableName = TypeVariableName.get((String)"X", (Type[])new Type[]{AmazonWebServiceRequest.class});
        ClassName dryRunResult = this.poetExtensions.getModelClass("DryRunResult");
        ParameterizedTypeName dryRunResultGeneric = ParameterizedTypeName.get((ClassName)dryRunResult, (TypeName[])new TypeName[]{typeVariableName});
        ClassName dryRunRequest = this.poetExtensions.getModelClass("DryRunSupportedRequest");
        ParameterizedTypeName dryRunRequestGeneric = ParameterizedTypeName.get((ClassName)dryRunRequest, (TypeName[])new TypeName[]{typeVariableName});
        return MethodSpec.methodBuilder((String)"dryRun").returns((TypeName)dryRunResultGeneric).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)dryRunRequestGeneric, "request", new Modifier[0]).addTypeVariable(typeVariableName).addStatement("$T<X> dryRunRequest = request.getDryRunRequest()", new Object[]{Request.class}).beginControlFlow("try", new Object[0]).addStatement("$T<$T> responseHandler = new $T<$T>(new $T())", new Object[]{StaxResponseHandler.class, dryRunResult, StaxResponseHandler.class, dryRunResult, VoidStaxUnmarshaller.class}).addStatement("\nclientHandler.execute(new $T<$T, $T>().withMarshaller($L).withResponseHandler($N).withInput($L))", new Object[]{ClientExecutionParams.class, Request.class, dryRunResult, "null", "responseHandler", "dryRunRequest"}).addStatement("throw new $T($S)", new Object[]{AmazonClientException.class, "Unrecognized service response for the dry-run request."}).endControlFlow().beginControlFlow("catch (AmazonServiceException ase)", new Object[0]).beginControlFlow("if (ase.getErrorCode().equals($S) && ase.getStatusCode() == 412)", new Object[]{"DryRunOperation"}).addStatement("return new $T(true, request, ase.getMessage(), ase)", new Object[]{dryRunResultGeneric}).endControlFlow().beginControlFlow("else if (ase.getErrorCode().equals($S) && ase.getStatusCode() == 403)", new Object[]{"UnauthorizedOperation"}).addStatement("return new $T(false, request, ase.getMessage(), ase)", new Object[]{dryRunResultGeneric}).endControlFlow().addStatement("throw new $T($S, ase)", new Object[]{AmazonClientException.class, "Unrecognized service response for the dry-run request."}).endControlFlow().build();
    }
}

