/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.sync.RequestBody;
import software.amazon.awssdk.sync.StreamingResponseHandler;

public final class SyncClientInterface
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName className;
    private final String clientPackageName;

    public SyncClientInterface(IntermediateModel model) {
        this.model = model;
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.className = ClassName.get((String)this.clientPackageName, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder classBuilder = PoetUtils.createInterfaceBuilder(this.className).addSuperinterface(AutoCloseable.class).addJavadoc(this.getJavadoc(), new Object[0]).addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getSigningName()}).build()).addMethod(this.create()).addMethod(this.builder()).addMethods(this.operations()).addMethod(this.serviceMetadata());
        if (this.model.getHasWaiters()) {
            classBuilder.addMethod(this.waiters());
        }
        if (this.model.getCustomizationConfig().getPresignersFqcn() != null) {
            classBuilder.addMethod(this.presigners());
        }
        return classBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getServiceAbbreviation() + ". This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    private Iterable<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::operationMethodSpec).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private MethodSpec serviceMetadata() {
        return MethodSpec.methodBuilder((String)"serviceMetadata").returns(ServiceMetadata.class).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("return $T.of($S)", new Object[]{ServiceMetadata.class, this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private List<MethodSpec> operationMethodSpec(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        if (opModel.getInputShape().isSimpleMethod()) {
            methods.add(this.simpleMethod(opModel));
        }
        methods.add(SyncClientInterface.operationMethodSignature(this.model, opModel).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build());
        return methods;
    }

    private MethodSpec simpleMethod(OperationModel opModel) {
        return SyncClientInterface.operationSimpleMethodSignature(this.model, opModel).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build();
    }

    public static MethodSpec.Builder operationMethodSignature(IntermediateModel model, OperationModel opModel) {
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ClassName requestType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)opModel.getMethodName()).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getSyncDocumentation(model, opModel), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
        SyncClientInterface.streamingMethod(methodBuilder, opModel);
        return methodBuilder;
    }

    public static MethodSpec.Builder operationSimpleMethodSignature(IntermediateModel model, OperationModel opModel) {
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)opModel.getMethodName()).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(opModel.getSyncDocumentation(model, opModel), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
        SyncClientInterface.streamingMethod(methodBuilder, opModel);
        return methodBuilder;
    }

    private static void streamingMethod(MethodSpec.Builder methodBuilder, OperationModel opModel) {
        if (opModel.hasStreamingInput()) {
            methodBuilder.addParameter((TypeName)ClassName.get(RequestBody.class), "requestBody", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            methodBuilder.addTypeVariable(AsyncClientInterface.STREAMING_TYPE_VARIABLE);
            methodBuilder.addParameter((TypeName)ClassName.get(StreamingResponseHandler.class), "streamingHandler", new Modifier[0]);
        }
    }

    private static List<ClassName> getExceptionClasses(IntermediateModel model, OperationModel opModel) {
        List exceptions = opModel.getExceptions().stream().map(e -> ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)e.getExceptionName(), (String[])new String[0])).collect(Collectors.toCollection(ArrayList::new));
        Collections.addAll(exceptions, ClassName.get(SdkBaseException.class), ClassName.get(SdkClientException.class), ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]));
        return exceptions;
    }

    private MethodSpec waiters() {
        return MethodSpec.methodBuilder((String)"waiters").returns((TypeName)ClassName.get((String)this.model.getMetadata().getFullWaitersPackageName(), (String)(this.model.getMetadata().getSyncInterface() + "Waiters"), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build();
    }

    private MethodSpec presigners() {
        ClassName presignerClassName = PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getPresignersFqcn());
        return MethodSpec.methodBuilder((String)"presigners").returns((TypeName)presignerClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build();
    }
}

