/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.WaiterDefinitionModel;
import software.amazon.awssdk.util.ImmutableMapParameter;

public class WaitersGeneratorTasks
extends BaseGeneratorTasks {
    private final String waiterClassDir;

    public WaitersGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.waiterClassDir = dependencies.getPathProvider().getWaitersDirectory();
    }

    private static boolean containsAllStatusMatchers(Map.Entry<String, WaiterDefinitionModel> entry) {
        return entry.getValue().getAcceptors().stream().allMatch(a -> a.getMatcher().equals("status"));
    }

    @Override
    protected boolean hasTasks() {
        return this.model.getHasWaiters();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting waiter classes");
        return Stream.of(this.createWaiterOpFunctionClassTasks(), this.createWaiterAcceptorClassTasks(), this.createWaiterClassTasks()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<GeneratorTask> createWaiterOpFunctionClassTasks() throws IOException {
        ArrayList<GeneratorTask> generatorTasks = new ArrayList<GeneratorTask>();
        ArrayList<String> generatedOperations = new ArrayList<String>();
        for (Map.Entry<String, WaiterDefinitionModel> entry : this.model.getWaiters().entrySet()) {
            WaiterDefinitionModel waiterModel = entry.getValue();
            if (generatedOperations.contains(waiterModel.getOperationName())) continue;
            generatedOperations.add(waiterModel.getOperationName());
            ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"waiter", (Object)waiterModel, (Object)"operation", (Object)this.model.getOperation(waiterModel.getOperationName()), (Object)"metadata", (Object)this.model.getMetadata());
            String className = waiterModel.getOperationModel().getOperationName() + "Function";
            generatorTasks.add(new FreemarkerGeneratorTask(this.waiterClassDir, className, this.freemarker.getWaiterSdkFunctionTemplate(), dataModel));
        }
        return generatorTasks;
    }

    private List<GeneratorTask> createWaiterAcceptorClassTasks() throws IOException {
        ArrayList<GeneratorTask> generatorTasks = new ArrayList<GeneratorTask>();
        for (Map.Entry<String, WaiterDefinitionModel> entry : this.model.getWaiters().entrySet()) {
            if (WaitersGeneratorTasks.containsAllStatusMatchers(entry)) continue;
            String waiterName = entry.getKey();
            WaiterDefinitionModel waiterModel = entry.getValue();
            ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"waiter", (Object)waiterModel, (Object)"operation", (Object)this.model.getOperation(waiterModel.getOperationName()), (Object)"metadata", (Object)this.model.getMetadata());
            generatorTasks.add(new FreemarkerGeneratorTask(this.waiterClassDir, waiterName, this.freemarker.getWaiterAcceptorTemplate(), dataModel));
        }
        return generatorTasks;
    }

    private List<GeneratorTask> createWaiterClassTasks() throws IOException {
        Metadata metadata = this.model.getMetadata();
        String className = metadata.getSyncInterface() + "Waiters";
        ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"className", (Object)className, (Object)"waiters", this.model.getWaiters(), (Object)"operation", this.model.getOperations(), (Object)"metadata", (Object)metadata);
        return Collections.singletonList(new FreemarkerGeneratorTask(this.waiterClassDir, className, this.freemarker.getWaiterTemplate(), dataModel));
    }
}

