/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.transform.protocols.MarshallerProtocolSpec;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.utils.StringUtils;

public class JsonMarshallerSpec
implements MarshallerProtocolSpec {
    private final Metadata metadata;
    private final ShapeModel shapeModel;
    private final PoetExtensions poetExtensions;

    public JsonMarshallerSpec(IntermediateModel model, ShapeModel shapeMode) {
        this.metadata = model.getMetadata();
        this.poetExtensions = new PoetExtensions(model);
        this.shapeModel = shapeMode;
    }

    @Override
    public ParameterSpec protocolFactoryParameter() {
        return ParameterSpec.builder(AwsJsonProtocolFactory.class, (String)"protocolFactory", (Modifier[])new Modifier[0]).build();
    }

    @Override
    public Optional<MethodSpec> constructor() {
        return Optional.of(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.protocolFactoryParameter()).addStatement("this.protocolFactory = protocolFactory", new Object[0]).build());
    }

    @Override
    public CodeBlock marshalCodeBlock(ClassName requestClassName) {
        String variableName = this.shapeModel.getVariable().getVariableName();
        return CodeBlock.builder().addStatement("$T<$T> protocolMarshaller = protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, $L)", new Object[]{ProtocolRequestMarshaller.class, requestClassName, variableName}).addStatement("protocolMarshaller.startMarshalling()", new Object[0]).addStatement("$T.getInstance().marshall($L, protocolMarshaller)", new Object[]{this.poetExtensions.getTransformClass(this.shapeModel.getShapeName() + "ModelMarshaller"), variableName}).addStatement("return protocolMarshaller.finishMarshalling()", new Object[0]).build();
    }

    @Override
    public FieldSpec protocolFactory() {
        return FieldSpec.builder(AwsJsonProtocolFactory.class, (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public List<FieldSpec> memberVariables() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        CodeBlock.Builder initializationCodeBlockBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{OperationInfo.class});
        initializationCodeBlockBuilder.add(".requestUri($S)", new Object[]{this.shapeModel.getMarshaller().getRequestUri()}).add(".httpMethodName($T.$L)", new Object[]{HttpMethodName.class, this.shapeModel.getMarshaller().getVerb()}).add(".hasExplicitPayloadMember($L)", new Object[]{this.shapeModel.isHasPayloadMember()}).add(".hasPayloadMembers($L)", new Object[]{this.shapeModel.hasPayloadMembers()});
        if (StringUtils.isNotBlank((CharSequence)this.shapeModel.getMarshaller().getTarget())) {
            initializationCodeBlockBuilder.add(".operationIdentifier($S)", new Object[]{this.shapeModel.getMarshaller().getTarget()}).add(".serviceName($S)", new Object[]{this.metadata.getServiceName()});
        }
        CodeBlock codeBlock = initializationCodeBlockBuilder.add(".build()", new Object[0]).build();
        FieldSpec instance = FieldSpec.builder((TypeName)ClassName.get(OperationInfo.class), (String)"SDK_OPERATION_BINDING", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(codeBlock).build();
        FieldSpec protocolFactory = this.protocolFactory();
        fields.add(instance);
        fields.add(protocolFactory);
        return fields;
    }
}

