/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class MapSetters
extends AbstractMemberSetters {
    private final TypeProvider typeProvider;

    MapSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
        this.typeProvider = typeProvider;
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        if (Utils.isMapWithEnumShape(this.memberModel())) {
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberModel().getFluentEnumGetterMethodName(), this.mapWithEnumAsParameter(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluent = new ArrayList<MethodSpec>();
        fluent.add(this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build());
        if (Utils.isMapWithEnumShape(this.memberModel())) {
            fluent.add(this.fluentSetterBuilder(this.memberModel().getFluentEnumGetterMethodName(), this.mapWithEnumAsParameter(), returnType).addCode(this.copySetterBodyWithModeledEnumParameter()).addStatement("return this", new Object[0]).build());
        }
        return fluent;
    }

    @Override
    public MethodSpec beanStyle() {
        MethodSpec.Builder builder = this.beanStyleSetterBuilder().addCode(this.memberModel().isCollectionWithBuilderMember() ? this.copySetterBuilderBody() : this.beanCopySetterBody());
        if (this.annotateJsonProperty()) {
            builder.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{this.memberModel().getHttp().getMarshallLocationName()}).build());
        }
        return builder.build();
    }

    private ParameterSpec mapWithEnumAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.mapWithEnumParameterType(this.memberModel().getMapModel()), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }
}

