/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.config.templates;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.codegen.model.config.templates.ChildTemplate;

public class TopLevelTemplate {
    private final String mainTemplate;
    private final List<ChildTemplate> childTemplates;

    @JsonCreator
    public TopLevelTemplate(@JsonProperty(value="mainTemplate") String mainTemplate, @JsonProperty(value="childTemplates") List<ChildTemplate> childTemplates) {
        this.mainTemplate = mainTemplate;
        this.childTemplates = childTemplates;
    }

    public static TopLevelTemplate merge(TopLevelTemplate config, TopLevelTemplate override) {
        if (override == null) {
            return config;
        }
        if (config == null) {
            return override;
        }
        String mainTemplate = override.getMainTemplate() == null ? config.getMainTemplate() : override.getMainTemplate();
        LinkedList<ChildTemplate> childTemplates = new LinkedList<ChildTemplate>();
        if (config.getChildTemplates() != null) {
            childTemplates.addAll(config.getChildTemplates());
        }
        if (override.getChildTemplates() != null) {
            childTemplates.addAll(override.getChildTemplates());
        }
        return new TopLevelTemplate(mainTemplate, childTemplates);
    }

    public String getMainTemplate() {
        return this.mainTemplate;
    }

    public List<ChildTemplate> getChildTemplates() {
        return this.childTemplates;
    }
}

