/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class ShapeModelSpec {
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    public ShapeModelSpec(ShapeModel shapeModel, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    ClassName className() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    public List<FieldSpec> fields() {
        return this.fields(Modifier.PRIVATE, Modifier.FINAL);
    }

    public List<FieldSpec> fields(Modifier ... modifiers) {
        return this.shapeModel.getNonStreamingMembers().stream().map(m -> this.asField((MemberModel)m, modifiers)).collect(Collectors.toList());
    }

    public FieldSpec asField(MemberModel memberModel, Modifier ... modifiers) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.typeProvider.fieldType(memberModel), (String)memberModel.getVariable().getVariableName(), (Modifier[])new Modifier[0]);
        if (modifiers != null) {
            builder.addModifiers(modifiers);
        }
        return builder.build();
    }
}

