/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.model.ListSetters;
import software.amazon.awssdk.codegen.poet.model.MapSetters;
import software.amazon.awssdk.codegen.poet.model.NonCollectionSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class AccessorsFactory {
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final IntermediateModel intermediateModel;

    public AccessorsFactory(ShapeModel shapeModel, IntermediateModel intermediateModel, TypeProvider typeProvider) {
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.intermediateModel = intermediateModel;
    }

    public MethodSpec beanStyleGetters(MemberModel memberModel) {
        return MethodSpec.methodBuilder((String)memberModel.getBeanStyleGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(this.typeProvider.parameterType(memberModel)).addStatement("return $N", new Object[]{memberModel.getVariable().getVariableName()}).build();
    }

    public List<MethodSpec> fluentSetterDeclarations(MemberModel memberModel, TypeName returnType) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
    }

    public List<MethodSpec> fluentSetters(MemberModel memberModel, TypeName returnType) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
    }

    public List<MethodSpec> beanStyleSetters(MemberModel memberModel) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
    }
}

