/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.common;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.util.StringUtils;

public final class EnumClass
implements ClassSpec {
    private static final String VALUE = "value";
    private final ShapeModel shape;
    private final ClassName className;

    public EnumClass(String enumPackage, ShapeModel shape) {
        this.shape = shape;
        this.className = ClassName.get((String)enumPackage, (String)shape.getShapeName(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder enumBuilder = PoetUtils.createEnumBuilder(this.className).addField(String.class, VALUE, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(PoetUtils.toStringBuilder().addStatement("return $N", new Object[]{VALUE}).build()).addMethod(this.fromValueSpec()).addMethod(this.createConstructor());
        PoetUtils.addDeprecated(arg_0 -> ((TypeSpec.Builder)enumBuilder).addAnnotation(arg_0), this.shape);
        PoetUtils.addJavadoc(x$0 -> enumBuilder.addJavadoc(x$0, new Object[0]), this.shape);
        this.shape.getEnums().forEach(e -> enumBuilder.addEnumConstant(e.getName(), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{e.getValue()}).build()));
        return enumBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        return Collections.singletonList(StaticImport.staticMethodImport(StringUtils.class, "isNullOrEmpty"));
    }

    private MethodSpec createConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, VALUE, new Modifier[0]).addStatement("this.$1N = $1N", new Object[]{VALUE}).build();
    }

    private MethodSpec fromValueSpec() {
        return MethodSpec.methodBuilder((String)"fromValue").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of valueOf.\n\n@param $N real value\n@return $T corresponding to the value\n", new Object[]{VALUE, this.className}).addParameter(String.class, VALUE, new Modifier[0]).beginControlFlow("if ($T.isNullOrEmpty($N))", new Object[]{StringUtils.class, VALUE}).addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, "Value cannot be null or empty!"}).endControlFlow().addStatement("return $1T.of($2T.values())\n.filter(e -> e.toString().equals($3N))\n.findFirst()\n.orElseThrow(() -> new $4T($5S + $3N + $6S))", new Object[]{Stream.class, this.className, VALUE, IllegalArgumentException.class, "Cannot create enum from ", " value!"}).build();
    }
}

