/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.codegen.model.intermediate.ExceptionModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetCollectors;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.opensdk.protect.client.SdkClientHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;

public class ApiGatewayProtocolSpec
extends JsonProtocolSpec {
    private final PoetExtensions poetExtensions;

    public ApiGatewayProtocolSpec(PoetExtensions poetExtensions) {
        super(poetExtensions);
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        ClassName protocolFactory = this.poetExtensions.getClientClass(model.getMetadata().getProtocolFactory());
        return FieldSpec.builder((TypeName)protocolFactory, (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        String exceptionPath = model.getSdkModeledExceptionBaseFqcn().substring(0, model.getSdkModeledExceptionBaseFqcn().lastIndexOf("."));
        ClassName baseException = ClassName.get((String)exceptionPath, (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]);
        ClassName protocolFactory = this.poetExtensions.getClientClass(model.getMetadata().getProtocolFactory());
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns((TypeName)protocolFactory).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("return new $T(new $T().withProtocolVersion($S).withSupportsCbor($L).withSupportsIon($L).withBaseServiceExceptionClass($L.class)", new Object[]{protocolFactory, JsonClientMetadata.class, model.getMetadata().getJsonVersion(), model.getMetadata().isCborProtocol(), model.getMetadata().isIonProtocol(), baseException});
        if (model.getMetadata().getContentType() != null) {
            methodSpec.addCode(".withContentTypeOverride($S)", new Object[]{model.getMetadata().getContentType()});
        }
        methodSpec.addCode(");", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock responseHandler(OperationModel opModel) {
        boolean isStreamingBody = opModel.getOutputShape() != null && opModel.getOutputShape().isHasStreamingMember();
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().add("\n\n$T<$T> responseHandler = $N.createResponseHandler(new $T().withPayloadJson($L).withHasStreamingSuccessResponse($L), new $T());", new Object[]{HttpResponseHandler.class, returnType, "protocolFactory", JsonOperationMetadata.class, !opModel.getHasBlobMemberAsPayload(), isStreamingBody, unmarshaller}).build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T<$T> errorResponseHandler = createErrorResponseHandler(", new Object[]{HttpResponseHandler.class, SdkBaseException.class}).add(this.errorMetadata(opModel)).add(");", new Object[0]).build();
    }

    private CodeBlock errorMetadata(OperationModel opModel) {
        return opModel.getExceptions().stream().map(this::exceptionModelToMetadata).collect(PoetCollectors.toDelimitedCodeBlock(", "));
    }

    private CodeBlock exceptionModelToMetadata(ExceptionModel exception) {
        ClassName exceptionClass = this.poetExtensions.getModelClass(exception.getExceptionName());
        return CodeBlock.of((String)"new JsonErrorShapeMetadata().withModeledClass($T.class).withHttpStatusCode($L)", (Object[])new Object[]{exceptionClass, exception.getHttpStatusCode()});
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>().withMarshaller(new $T($N)).withResponseHandler($N).withErrorResponseHandler($N).withInput($L));", new Object[]{ClientExecutionParams.class, requestType, returnType, marshaller, "protocolFactory", "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()}).build();
    }

    @Override
    public Class<? extends ClientHandler> getClientHandlerClass() {
        return SdkClientHandler.class;
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        ClassName httpResponseHandler = ClassName.get(HttpResponseHandler.class);
        ClassName sdkBaseException = ClassName.get(SdkBaseException.class);
        ParameterizedTypeName responseHandlerOfException = ParameterizedTypeName.get((ClassName)httpResponseHandler, (TypeName[])new TypeName[]{sdkBaseException});
        TypeName errorMetadataArray = ArrayTypeName.get(JsonErrorShapeMetadata[].class);
        return Optional.of(MethodSpec.methodBuilder((String)"createErrorResponseHandler").returns((TypeName)responseHandlerOfException).addParameter(errorMetadataArray, "errorShapeMetadata", new Modifier[0]).varargs().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return protocolFactory.createErrorResponseHandler(new $T().withErrorShapes($T.asList(errorShapeMetadata)))", new Object[]{JsonErrorResponseMetadata.class, Arrays.class}).build());
    }
}

