/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.builder.SyncClientBuilderClass;
import software.amazon.awssdk.codegen.poet.builder.SyncClientBuilderInterface;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;

public class SyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public SyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Sync client classes");
        return Arrays.asList(this.createClientClassTask(), this.createClientBuilderTask(), this.createClientInterfaceTask(), this.createClientBuilderInterfaceTask());
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientClass(this.generatorTaskParams));
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientBuilderClass(this.model));
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientInterface(this.model));
    }

    private GeneratorTask createClientBuilderInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientBuilderInterface(this.model));
    }
}

