/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.AuthPolicyActions;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.util.ImmutableMapParameter;

public class PolicyActionEnumGeneratorTasks
extends BaseGeneratorTasks {
    private final String policyEnumClassDir;
    private final AuthPolicyActions policyActions;
    private final Metadata metadata;

    public PolicyActionEnumGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.policyEnumClassDir = dependencies.getPathProvider().getPolicyEnumDirectory();
        this.policyActions = this.model.getCustomizationConfig().getAuthPolicyActions();
        this.metadata = this.model.getMetadata();
    }

    @Override
    protected boolean hasTasks() {
        AuthPolicyActions policyActions = this.model.getCustomizationConfig().getAuthPolicyActions();
        return policyActions == null || !policyActions.isSkip();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting policy action enum class");
        String serviceName = this.getPolicyActionServiceName();
        String actionPrefix = this.getEnumActionPrefix();
        ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"operations", this.model.getOperations().keySet(), (Object)"metadata", (Object)this.model.getMetadata(), (Object)"serviceName", (Object)serviceName, (Object)"actionPrefix", (Object)actionPrefix);
        return Collections.singletonList(new FreemarkerGeneratorTask(new CodeWriter(this.policyEnumClassDir, serviceName + "Actions"), this.freemarker.getPolicyActionClassTemplate(), dataModel));
    }

    private String getPolicyActionServiceName() {
        if (this.policyActions != null && this.policyActions.getFileNamePrefix() != null) {
            return Utils.capitialize(this.policyActions.getFileNamePrefix());
        }
        return Utils.capitialize(this.metadata.getEndpointPrefix());
    }

    private String getEnumActionPrefix() {
        if (this.policyActions != null && this.policyActions.getActionPrefix() != null) {
            return this.policyActions.getActionPrefix();
        }
        return this.metadata.getEndpointPrefix();
    }
}

