/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.amazon.awssdk.codegen.C2jModels;
import software.amazon.awssdk.codegen.CodeGenerator;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.BasicCodeGenConfig;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.service.Paginators;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Waiters;
import software.amazon.awssdk.codegen.utils.ModelLoaderUtils;

@Mojo(name="generate")
public class GenerationMojo
extends AbstractMojo {
    private static final String MODEL_FILE = "service-2.json";
    private static final String CODE_GEN_CONFIG_FILE = "codegen.config";
    private static final String CUSTOMIZATION_CONFIG_FILE = "customization.config";
    private static final String EXAMPLES_FILE = "examples-1.json";
    private static final String WAITERS_FILE = "waiters-2.json";
    private static final String PAGINATORS_FILE = "paginators-1.json";
    @Parameter(property="codeGenResources", defaultValue="${basedir}/src/main/resources/codegen-resources/")
    private File codeGenResources;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private Path sourcesDirectory;
    private Path testsDirectory;

    public void execute() throws MojoExecutionException {
        this.sourcesDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-sources").resolve("sdk");
        this.testsDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-test-sources").resolve("sdk-tests");
        this.findModelRoots().forEach(p -> {
            try {
                this.getLog().info((CharSequence)("Loading from: " + p.toString()));
                this.generateCode(((C2jModels.Builder)C2jModels.builder().applyMutation(b -> this.loadCodeGenConfig((Path)p).ifPresent(arg_0 -> ((C2jModels.Builder)b).codeGenConfig(arg_0)))).customizationConfig(this.loadCustomizationConfig((Path)p)).serviceModel(this.loadServiceModel((Path)p)).waitersModel(this.loadWaiterModel((Path)p)).paginatorsModel(this.loadPaginatorModel((Path)p)).examplesModel(this.loadExamplesModel((Path)p)).build());
            }
            catch (MojoExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        this.project.addCompileSourceRoot(this.sourcesDirectory.toFile().getAbsolutePath());
        this.project.addTestCompileSourceRoot(this.testsDirectory.toFile().getAbsolutePath());
    }

    private Stream<Path> findModelRoots() throws MojoExecutionException {
        try {
            return Files.find(this.codeGenResources.toPath(), 10, this::isModelFile, new FileVisitOption[0]).map(Path::getParent).sorted(this::modelSharersLast);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find 'service-2.json' files in " + this.codeGenResources, (Exception)e);
        }
    }

    private int modelSharersLast(Path lhs, Path rhs) {
        return this.loadCustomizationConfig(lhs).getShareModelConfig() == null ? -1 : 1;
    }

    private boolean isModelFile(Path p, BasicFileAttributes a) {
        return p.toString().endsWith(MODEL_FILE);
    }

    private void generateCode(C2jModels models) {
        CodeGenerator.builder().models(models).sourcesDirectory(this.sourcesDirectory.toFile().getAbsolutePath()).testsDirectory(this.testsDirectory.toFile().getAbsolutePath()).fileNamePrefix(Utils.getFileNamePrefix((ServiceModel)models.serviceModel())).build().execute();
    }

    private Optional<BasicCodeGenConfig> loadCodeGenConfig(Path root) {
        return this.loadOptionalModel(BasicCodeGenConfig.class, root.resolve(CODE_GEN_CONFIG_FILE));
    }

    private CustomizationConfig loadCustomizationConfig(Path root) {
        return this.loadOptionalModel(CustomizationConfig.class, root.resolve(CUSTOMIZATION_CONFIG_FILE)).orElse(CustomizationConfig.create());
    }

    private ServiceModel loadServiceModel(Path root) throws MojoExecutionException {
        return this.loadRequiredModel(ServiceModel.class, root.resolve(MODEL_FILE));
    }

    private ServiceExamples loadExamplesModel(Path root) {
        return this.loadOptionalModel(ServiceExamples.class, root.resolve(EXAMPLES_FILE)).orElse(ServiceExamples.none());
    }

    private Waiters loadWaiterModel(Path root) {
        return this.loadOptionalModel(Waiters.class, root.resolve(WAITERS_FILE)).orElse(Waiters.none());
    }

    private Paginators loadPaginatorModel(Path root) {
        return this.loadOptionalModel(Paginators.class, root.resolve(PAGINATORS_FILE)).orElse(Paginators.none());
    }

    private <T> T loadRequiredModel(Class<T> clzz, Path location) throws MojoExecutionException {
        return (T)ModelLoaderUtils.loadModel(clzz, (File)location.toFile());
    }

    private <T> Optional<T> loadOptionalModel(Class<T> clzz, Path location) {
        return ModelLoaderUtils.loadOptionalModel(clzz, (File)location.toFile());
    }
}

