/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.RegionValidationUtil;
import software.amazon.awssdk.codegen.lite.regions.model.Endpoint;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.codegen.lite.regions.model.Service;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.Validate;

public class ServiceMetadataGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String serviceEndpointPrefix;
    private final String basePackage;
    private final String regionBasePackage;

    public ServiceMetadataGenerator(Partitions partitions, String serviceEndpointPrefix, String basePackage, String regionBasePackage) {
        this.partitions = partitions;
        this.serviceEndpointPrefix = serviceEndpointPrefix;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
        this.removeBadRegions();
    }

    private void removeBadRegions() {
        this.partitions.getPartitions().forEach(partition -> partition.getServices().values().forEach(service -> {
            Iterator<Map.Entry<String, Endpoint>> endpointIterator = service.getEndpoints().entrySet().iterator();
            while (endpointIterator.hasNext()) {
                Map.Entry<String, Endpoint> entry = endpointIterator.next();
                String endpointName = entry.getKey();
                Endpoint endpoint = entry.getValue();
                if (RegionValidationUtil.validRegion(endpointName, partition.getRegionRegex()) && RegionValidationUtil.validEndpoint(endpointName, endpoint)) continue;
                endpointIterator.remove();
            }
        }));
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName listOfRegions = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])});
        ParameterizedTypeName mapByServiceEndpointKey = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.serviceEndpointKeyClass(), ClassName.get(String.class)});
        ParameterizedTypeName mapByPair = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.byPartitionKeyClass(), ClassName.get(String.class)});
        ParameterizedTypeName listOfServicePartitionMetadata = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"ServicePartitionMetadata", (String[])new String[0])});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"ServiceMetadata", (String[])new String[0])).addField(FieldSpec.builder(String.class, (String)"ENDPOINT_PREFIX", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.serviceEndpointPrefix}).build()).addField(FieldSpec.builder((TypeName)listOfRegions, (String)"REGIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.regionsField(this.partitions)).build()).addField(FieldSpec.builder((TypeName)listOfServicePartitionMetadata, (String)"PARTITIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.servicePartitions(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByServiceEndpointKey, (String)"SIGNING_REGIONS_BY_REGION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.signingRegionsByRegion(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByPair, (String)"SIGNING_REGIONS_BY_PARTITION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.signingRegionsByPartition(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByServiceEndpointKey, (String)"DNS_SUFFIXES_BY_REGION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.dnsSuffixesByRegion(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByPair, (String)"DNS_SUFFIXES_BY_PARTITION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.dnsSuffixesByPartition(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByServiceEndpointKey, (String)"HOSTNAMES_BY_REGION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.hostnamesByRegion(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapByPair, (String)"HOSTNAMES_BY_PARTITION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.hostnamesByPartition(this.partitions)).build()).addMethod(this.regions()).addMethod(this.partitions((TypeName)listOfServicePartitionMetadata)).addMethod(this.endpointFor()).addMethod(this.signingRegion()).build();
    }

    @Override
    public ClassName className() {
        String sanitizedServiceName = this.serviceEndpointPrefix.replace(".", "-");
        return ClassName.get((String)this.basePackage, (String)(Stream.of(sanitizedServiceName.split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "ServiceMetadata"), (String[])new String[0]);
    }

    private CodeBlock signingRegionsByRegion(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.serviceEndpointKeyClass(), String.class});
        services.forEach((partition, service) -> service.getEndpoints().forEach((region, endpoint) -> {
            if (endpoint.getCredentialScope() != null && endpoint.getCredentialScope().getRegion() != null) {
                builder.add(".put(", new Object[0]).add(this.serviceEndpointKey((String)region, (Collection<String>)Collections.emptyList())).add(", $S)\n", new Object[]{endpoint.getCredentialScope().getRegion()});
                endpoint.getVariants().forEach(variant -> builder.add(".put(", new Object[0]).add(this.serviceEndpointKey((String)region, (Collection<String>)variant.getTags())).add(", $S)\n", new Object[]{endpoint.getCredentialScope().getRegion()}));
            }
        }));
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock signingRegionsByPartition(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.byPartitionKeyClass(), String.class});
        services.forEach((partition, service) -> {
            Endpoint partitionDefaults = service.getDefaults();
            if (partitionDefaults != null && partitionDefaults.getCredentialScope() != null && partitionDefaults.getCredentialScope().getRegion() != null) {
                builder.add(".put($T.of($S, ", new Object[]{Pair.class, partition.getPartition()}).add(this.partitionEndpointKey(Collections.emptyList())).add("), $S)\n", new Object[]{partitionDefaults.getCredentialScope().getRegion()});
                partitionDefaults.getVariants().forEach(variant -> builder.add(".put($T.of($S, ", new Object[]{Pair.class, partition.getPartition()}).add(this.partitionEndpointKey(variant.getTags())).add("), $S)\n", new Object[]{partitionDefaults.getCredentialScope().getRegion()}));
            }
        });
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock dnsSuffixesByRegion(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.serviceEndpointKeyClass(), String.class});
        services.forEach((partition, service) -> service.getEndpoints().forEach((region, endpoint) -> endpoint.getVariants().forEach(variant -> {
            if (variant.getDnsSuffix() != null) {
                builder.add(".put(", new Object[0]).add(this.serviceEndpointKey((String)region, (Collection<String>)variant.getTags())).add(", $S)\n", new Object[]{variant.getDnsSuffix()});
            }
        })));
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock dnsSuffixesByPartition(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.byPartitionKeyClass(), String.class});
        services.forEach((partition, service) -> {
            if (service.getDefaults() != null) {
                service.getDefaults().getVariants().forEach(variant -> {
                    if (variant.getDnsSuffix() != null) {
                        builder.add(".put($T.of($S, ", new Object[]{Pair.class, partition.getPartition()}).add(this.partitionEndpointKey(variant.getTags())).add("), $S)\n", new Object[]{variant.getDnsSuffix()});
                    }
                });
            }
        });
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock hostnamesByRegion(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.serviceEndpointKeyClass(), String.class});
        services.forEach((partition, service) -> service.getEndpoints().forEach((region, endpoint) -> {
            if (endpoint.getHostname() != null) {
                builder.add(".put(", new Object[0]).add(this.serviceEndpointKey((String)region, (Collection<String>)Collections.emptyList())).add(", $S)\n", new Object[]{endpoint.getHostname()});
            }
            endpoint.getVariants().forEach(variant -> {
                if (variant.getHostname() != null) {
                    builder.add(".put(", new Object[0]).add(this.serviceEndpointKey((String)region, (Collection<String>)variant.getTags())).add(", $S)\n", new Object[]{variant.getHostname()});
                }
            });
        }));
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock hostnamesByPartition(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.byPartitionKeyClass(), String.class});
        services.forEach((partition, service) -> {
            if (service.getDefaults() != null) {
                if (service.getDefaults().getHostname() != null) {
                    builder.add(".put($T.of($S, ", new Object[]{Pair.class, partition.getPartition()}).add(this.partitionEndpointKey(Collections.emptyList())).add(", $S)\n", new Object[]{service.getDefaults().getHostname()});
                }
                service.getDefaults().getVariants().forEach(variant -> {
                    if (variant.getHostname() != null) {
                        builder.add(".put($T.of($S, ", new Object[]{Pair.class, partition.getPartition()}).add(this.partitionEndpointKey(variant.getTags())).add("), $S)\n", new Object[]{variant.getHostname()});
                    }
                });
            }
        });
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock serviceEndpointKey(String region, Collection<String> tags) {
        Validate.paramNotBlank((CharSequence)region, (String)"region");
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("$T.builder()", new Object[]{this.serviceEndpointKeyClass()}).add(".region($T.of($S))", new Object[]{this.regionClass(), region});
        if (!tags.isEmpty()) {
            CodeBlock tagsParameter = (CodeBlock)tags.stream().map(tag -> CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{this.endpointTagClass(), tag})).collect(CodeBlock.joining((String)", "));
            result.add(".tags(", new Object[0]).add(tagsParameter).add(")", new Object[0]);
        }
        result.add(".build()", new Object[0]);
        return result.build();
    }

    private CodeBlock partitionEndpointKey(Collection<String> tags) {
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("$T.builder()", new Object[]{this.partitionEndpointKeyClass()});
        if (!tags.isEmpty()) {
            CodeBlock tagsParameter = (CodeBlock)tags.stream().map(tag -> CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{this.endpointTagClass(), tag})).collect(CodeBlock.joining((String)", "));
            result.add(".tags(", new Object[0]).add(tagsParameter).add(")", new Object[0]);
        }
        result.add(".build()", new Object[0]);
        return result.build();
    }

    private CodeBlock regionsField(Partitions partitions) {
        ClassName regionClass = ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class});
        ArrayList regions = new ArrayList();
        partitions.getPartitions().stream().filter(p -> p.getServices().containsKey(this.serviceEndpointPrefix)).forEach(p -> regions.addAll(p.getServices().get(this.serviceEndpointPrefix).getEndpoints().keySet()));
        for (int i = 0; i < regions.size(); ++i) {
            builder.add("$T.of($S)", new Object[]{regionClass, regions.get(i)});
            if (i == regions.size() - 1) continue;
            builder.add(",", new Object[0]);
        }
        return builder.add("))", new Object[0]).build();
    }

    private CodeBlock servicePartitions(Partitions partitions) {
        return CodeBlock.builder().add("$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class}).add(this.commaSeparatedServicePartitions(partitions)).add("))", new Object[0]).build();
    }

    private CodeBlock commaSeparatedServicePartitions(Partitions partitions) {
        ClassName defaultServicePartitionMetadata = ClassName.get((String)(this.regionBasePackage + ".internal"), (String)"DefaultServicePartitionMetadata", (String[])new String[0]);
        return (CodeBlock)partitions.getPartitions().stream().filter(p -> p.getServices().containsKey(this.serviceEndpointPrefix)).map(p -> CodeBlock.of((String)"new $T($S, $L)", (Object[])new Object[]{defaultServicePartitionMetadata, p.getPartition(), this.globalRegion((Partition)p)})).collect(CodeBlock.joining((String)","));
    }

    private CodeBlock globalRegion(Partition partition) {
        ClassName region = ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]);
        Service service = partition.getServices().get(this.serviceEndpointPrefix);
        boolean hasGlobalRegionForPartition = service.isRegionalized() != null && service.isRegionalized() == false && service.isPartitionWideEndpointAvailable();
        String globalRegionForPartition = hasGlobalRegionForPartition ? service.getPartitionEndpoint() : null;
        return globalRegionForPartition == null ? CodeBlock.of((String)"null", (Object[])new Object[0]) : CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{region, globalRegionForPartition});
    }

    private MethodSpec regions() {
        ParameterizedTypeName listOfRegions = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])});
        return MethodSpec.methodBuilder((String)"regions").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)listOfRegions).addStatement("return $L", new Object[]{"REGIONS"}).build();
    }

    private MethodSpec endpointFor() {
        return MethodSpec.methodBuilder((String)"endpointFor").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.serviceEndpointKeyClass(), "key", new Modifier[0]).addAnnotation(Override.class).returns(URI.class).addCode("return $T.endpointFor(", new Object[]{this.serviceMetadataUtilsClass()}).addCode("$T.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ", new Object[]{this.serviceMetadataUtilsClass()}).addCode("ENDPOINT_PREFIX, ", new Object[0]).addCode("key.region().id(), ", new Object[0]).addCode("$T.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));", new Object[]{this.serviceMetadataUtilsClass()}).build();
    }

    private MethodSpec signingRegion() {
        return MethodSpec.methodBuilder((String)"signingRegion").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.serviceEndpointKeyClass(), "key", new Modifier[0]).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])).addStatement("return $T.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION)", new Object[]{this.serviceMetadataUtilsClass()}).build();
    }

    private MethodSpec partitions(TypeName listOfServicePartitionMetadata) {
        return MethodSpec.methodBuilder((String)"servicePartitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(listOfServicePartitionMetadata).addStatement("return $L", new Object[]{"PARTITIONS"}).build();
    }

    private Map<Partition, Service> getServiceData(Partitions partitions) {
        TreeMap<Partition, Service> serviceData = new TreeMap<Partition, Service>(Comparator.comparing(Partition::getPartition));
        partitions.getPartitions().forEach(p -> p.getServices().entrySet().stream().filter(s -> ((String)s.getKey()).equalsIgnoreCase(this.serviceEndpointPrefix)).forEach(s -> {
            Service cfr_ignored_0 = (Service)serviceData.put((Partition)p, (Service)s.getValue());
        }));
        return serviceData;
    }

    private ClassName serviceEndpointKeyClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"ServiceEndpointKey", (String[])new String[0]);
    }

    private ClassName partitionEndpointKeyClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"PartitionEndpointKey", (String[])new String[0]);
    }

    private ClassName regionClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]);
    }

    private ClassName endpointTagClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"EndpointTag", (String[])new String[0]);
    }

    private TypeName byPartitionKeyClass() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Pair.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.partitionEndpointKeyClass()});
    }

    private ClassName serviceMetadataUtilsClass() {
        return ClassName.get((String)(this.regionBasePackage + ".internal.util"), (String)"ServiceMetadataUtils", (String[])new String[0]);
    }
}

