/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.lite.regions.model.Endpoint;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class RegionValidationUtil {
    private static final Set<String> DEPRECATED_REGIONS_ALLOWSLIST = new HashSet<String>();
    private static final String FIPS_SUFFIX = "-fips";
    private static final String FIPS_PREFIX = "fips-";

    private RegionValidationUtil() {
    }

    public static boolean validRegion(String region, String regex) {
        return RegionValidationUtil.matchesRegex(region, regex) || RegionValidationUtil.matchesRegexFipsSuffix(region, regex) || RegionValidationUtil.matchesRegexFipsPrefix(region, regex) || RegionValidationUtil.isGlobal(region);
    }

    public static boolean validEndpoint(String region, Endpoint endpoint) {
        boolean invalidEndpoint = Boolean.TRUE.equals(endpoint.getDeprecated()) && !DEPRECATED_REGIONS_ALLOWSLIST.contains(region);
        return !invalidEndpoint;
    }

    private static boolean matchesRegex(String region, String regex) {
        return region.matches(regex);
    }

    private static boolean matchesRegexFipsSuffix(String region, String regex) {
        return region.replace(FIPS_SUFFIX, "").matches(regex);
    }

    private static boolean matchesRegexFipsPrefix(String region, String regex) {
        return region.replace(FIPS_PREFIX, "").matches(regex);
    }

    private static boolean isGlobal(String region) {
        return region.contains("global");
    }

    static {
        try (InputStream allowListStream = RegionValidationUtil.class.getResourceAsStream("/software/amazon/awssdk/codegen/lite/DeprecatedRegionsAllowlist.txt");){
            Validate.notNull((Object)allowListStream, (String)"Failed to load deprecated regions allowlist.", (Object[])new Object[0]);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(allowListStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    DEPRECATED_REGIONS_ALLOWSLIST.add(StringUtils.trim((String)line));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

