/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegenerationjsonrpccustomized;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.AllTypesRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.AllTypesResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.EmptyModeledException;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.NestedContainersRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.NestedContainersResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingOutputOperationResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.NestedContainersRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.NestedContainersResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.OperationWithNoInputOrOutputRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.OperationWithNoInputOrOutputResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingInputOperationRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingInputOperationResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingOutputOperationRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingOutputOperationResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CodeGenerationJsonRpcCustomizedAsyncClient}.
 *
 * @see CodeGenerationJsonRpcCustomizedAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeGenerationJsonRpcCustomizedAsyncClient implements CodeGenerationJsonRpcCustomizedAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultCodeGenerationJsonRpcCustomizedAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGenerationJsonRpcCustomizedException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodeGenerationJsonRpcCustomizedAsyncClient.AllTypes
     */
    @Override
    public CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        try {

            HttpResponseHandler<AllTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AllTypesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                    .withMarshaller(new AllTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @param nestedContainersRequest
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGenerationJsonRpcCustomizedException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodeGenerationJsonRpcCustomizedAsyncClient.NestedContainers
     */
    @Override
    public CompletableFuture<NestedContainersResponse> nestedContainers(NestedContainersRequest nestedContainersRequest) {
        try {

            HttpResponseHandler<NestedContainersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new NestedContainersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<NestedContainersRequest, NestedContainersResponse>()
                    .withMarshaller(new NestedContainersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(nestedContainersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGenerationJsonRpcCustomizedException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodeGenerationJsonRpcCustomizedAsyncClient.OperationWithNoInputOrOutput
     */
    @Override
    public CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) {
        try {

            HttpResponseHandler<OperationWithNoInputOrOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new OperationWithNoInputOrOutputResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<OperationWithNoInputOrOutputRequest, OperationWithNoInputOrOutputResponse>()
                            .withMarshaller(new OperationWithNoInputOrOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(operationWithNoInputOrOutputRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.
     *
     * @param streamingInputOperationRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGenerationJsonRpcCustomizedException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodeGenerationJsonRpcCustomizedAsyncClient.StreamingInputOperation
     */
    @Override
    public CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, AsyncRequestBody requestBody) {
        try {

            HttpResponseHandler<StreamingInputOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StreamingInputOperationResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<StreamingInputOperationRequest, StreamingInputOperationResponse>()
                            .withMarshaller(new StreamingInputOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withAsyncRequestBody(requestBody).withInput(streamingInputOperationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.
     *
     * @param streamingOutputOperationRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGenerationJsonRpcCustomizedException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodeGenerationJsonRpcCustomizedAsyncClient.StreamingOutputOperation
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest,
            AsyncResponseTransformer<StreamingOutputOperationResponse, ReturnT> asyncResponseTransformer) {
        try {

            HttpResponseHandler<StreamingOutputOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true),
                    new StreamingOutputOperationResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(
                    new ClientExecutionParams<StreamingOutputOperationRequest, StreamingOutputOperationResponse>()
                            .withMarshaller(new StreamingOutputOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(streamingOutputOperationRequest), asyncResponseTransformer);
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(
                                software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.CodeGenerationJsonRpcCustomizedException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("EmptyModeledException").withModeledClass(
                                        EmptyModeledException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
