/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentReadyOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentReadyOption> {
    private static final SdkField<String> ACTION_ON_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentReadyOption.getter(DeploymentReadyOption::actionOnTimeoutAsString)).setter(DeploymentReadyOption.setter(Builder::actionOnTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionOnTimeout").build()}).build();
    private static final SdkField<Integer> WAIT_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeploymentReadyOption.getter(DeploymentReadyOption::waitTimeInMinutes)).setter(DeploymentReadyOption.setter(Builder::waitTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitTimeInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ON_TIMEOUT_FIELD, WAIT_TIME_IN_MINUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionOnTimeout;
    private final Integer waitTimeInMinutes;

    private DeploymentReadyOption(BuilderImpl builder) {
        this.actionOnTimeout = builder.actionOnTimeout;
        this.waitTimeInMinutes = builder.waitTimeInMinutes;
    }

    public DeploymentReadyAction actionOnTimeout() {
        return DeploymentReadyAction.fromValue(this.actionOnTimeout);
    }

    public String actionOnTimeoutAsString() {
        return this.actionOnTimeout;
    }

    public Integer waitTimeInMinutes() {
        return this.waitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnTimeoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitTimeInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentReadyOption)) {
            return false;
        }
        DeploymentReadyOption other = (DeploymentReadyOption)obj;
        return Objects.equals(this.actionOnTimeoutAsString(), other.actionOnTimeoutAsString()) && Objects.equals(this.waitTimeInMinutes(), other.waitTimeInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentReadyOption").add("ActionOnTimeout", (Object)this.actionOnTimeoutAsString()).add("WaitTimeInMinutes", (Object)this.waitTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionOnTimeout": {
                return Optional.ofNullable(clazz.cast(this.actionOnTimeoutAsString()));
            }
            case "waitTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.waitTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentReadyOption, T> g) {
        return obj -> g.apply((DeploymentReadyOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionOnTimeout;
        private Integer waitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentReadyOption model) {
            this.actionOnTimeout(model.actionOnTimeout);
            this.waitTimeInMinutes(model.waitTimeInMinutes);
        }

        public final String getActionOnTimeoutAsString() {
            return this.actionOnTimeout;
        }

        @Override
        public final Builder actionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
            return this;
        }

        @Override
        public final Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout.toString());
            return this;
        }

        public final void setActionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
        }

        public final Integer getWaitTimeInMinutes() {
            return this.waitTimeInMinutes;
        }

        @Override
        public final Builder waitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
            return this;
        }

        public final void setWaitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
        }

        public DeploymentReadyOption build() {
            return new DeploymentReadyOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentReadyOption> {
        public Builder actionOnTimeout(String var1);

        public Builder actionOnTimeout(DeploymentReadyAction var1);

        public Builder waitTimeInMinutes(Integer var1);
    }
}

