/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationRevisionResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, GetApplicationRevisionResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApplicationRevisionResponse.getter(GetApplicationRevisionResponse::applicationName)).setter(GetApplicationRevisionResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetApplicationRevisionResponse.getter(GetApplicationRevisionResponse::revision)).setter(GetApplicationRevisionResponse.setter(Builder::revision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<GenericRevisionInfo> REVISION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetApplicationRevisionResponse.getter(GetApplicationRevisionResponse::revisionInfo)).setter(GetApplicationRevisionResponse.setter(Builder::revisionInfo)).constructor(GenericRevisionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, REVISION_FIELD, REVISION_INFO_FIELD));
    private final String applicationName;
    private final RevisionLocation revision;
    private final GenericRevisionInfo revisionInfo;

    private GetApplicationRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
        this.revisionInfo = builder.revisionInfo;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public GenericRevisionInfo revisionInfo() {
        return this.revisionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionResponse)) {
            return false;
        }
        GetApplicationRevisionResponse other = (GetApplicationRevisionResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.revisionInfo(), other.revisionInfo());
    }

    public String toString() {
        return ToString.builder((String)"GetApplicationRevisionResponse").add("ApplicationName", (Object)this.applicationName()).add("Revision", (Object)this.revision()).add("RevisionInfo", (Object)this.revisionInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "revisionInfo": {
                return Optional.ofNullable(clazz.cast(this.revisionInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationRevisionResponse, T> g) {
        return obj -> g.apply((GetApplicationRevisionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private String applicationName;
        private RevisionLocation revision;
        private GenericRevisionInfo revisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionResponse model) {
            super(model);
            this.applicationName(model.applicationName);
            this.revision(model.revision);
            this.revisionInfo(model.revisionInfo);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final GenericRevisionInfo.Builder getRevisionInfo() {
            return this.revisionInfo != null ? this.revisionInfo.toBuilder() : null;
        }

        @Override
        public final Builder revisionInfo(GenericRevisionInfo revisionInfo) {
            this.revisionInfo = revisionInfo;
            return this;
        }

        public final void setRevisionInfo(GenericRevisionInfo.BuilderImpl revisionInfo) {
            this.revisionInfo = revisionInfo != null ? revisionInfo.build() : null;
        }

        @Override
        public GetApplicationRevisionResponse build() {
            return new GetApplicationRevisionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationRevisionResponse> {
        public Builder applicationName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(revision)).build());
        }

        public Builder revisionInfo(GenericRevisionInfo var1);

        default public Builder revisionInfo(Consumer<GenericRevisionInfo.Builder> revisionInfo) {
            return this.revisionInfo((GenericRevisionInfo)((GenericRevisionInfo.Builder)GenericRevisionInfo.builder().applyMutation(revisionInfo)).build());
        }
    }
}

