/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ErrorInformation.Builder, ErrorInformation> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ErrorInformation::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(ErrorInformation::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private ErrorInformation(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for CodeDeploy</a> in
     * the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User Guide</a>.
     * </p>
     * <p>
     * The error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is
     * deleted after the deployment is created, but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
     * deployment group is deleted after the deployment is created, but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance
     * health constraints specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_MISSING: The service role cannot be accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * INTERNAL_ERROR: There was an internal error.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_INSTANCES: No instances were specified, or no instances can be found.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more
     * Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT: The deployment has timed out.
     * </p>
     * </li>
     * <li>
     * <p>
     * REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted
     * after the deployment is created, but before it is started.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return For more information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
     *         CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User
     *         Guide</a>.</p>
     *         <p>
     *         The error code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         APPLICATION_MISSING: The application was missing. This error code is most likely raised if the
     *         application is deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
     *         deployment group is deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
     *         instance health constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
     *         constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_MISSING: The service role cannot be accessed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INTERNAL_ERROR: There was an internal error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_INSTANCES: No instances were specified, or no instances can be found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one
     *         or more Amazon Web Services services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT: The deployment has timed out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is
     *         deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     * @see ErrorCode
     */
    public final ErrorCode code() {
        return ErrorCode.fromValue(code);
    }

    /**
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for CodeDeploy</a> in
     * the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User Guide</a>.
     * </p>
     * <p>
     * The error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is
     * deleted after the deployment is created, but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
     * deployment group is deleted after the deployment is created, but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance
     * health constraints specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_MISSING: The service role cannot be accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * INTERNAL_ERROR: There was an internal error.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_INSTANCES: No instances were specified, or no instances can be found.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more
     * Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT: The deployment has timed out.
     * </p>
     * </li>
     * <li>
     * <p>
     * REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted
     * after the deployment is created, but before it is started.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return For more information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
     *         CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User
     *         Guide</a>.</p>
     *         <p>
     *         The error code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         APPLICATION_MISSING: The application was missing. This error code is most likely raised if the
     *         application is deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
     *         deployment group is deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
     *         instance health constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
     *         constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_MISSING: The service role cannot be accessed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INTERNAL_ERROR: There was an internal error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_INSTANCES: No instances were specified, or no instances can be found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one
     *         or more Amazon Web Services services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT: The deployment has timed out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is
     *         deleted after the deployment is created, but before it is started.
     *         </p>
     *         </li>
     * @see ErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * An accompanying error message.
     * </p>
     * 
     * @return An accompanying error message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInformation)) {
            return false;
        }
        ErrorInformation other = (ErrorInformation) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInformation").add("Code", codeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorInformation, T> g) {
        return obj -> g.apply((ErrorInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInformation> {
        /**
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
         * CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User
         * Guide</a>.
         * </p>
         * <p>
         * The error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is
         * deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
         * deployment group is deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         * instance health constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         * constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_MISSING: The service role cannot be accessed.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * INTERNAL_ERROR: There was an internal error.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_INSTANCES: No instances were specified, or no instances can be found.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or
         * more Amazon Web Services services.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: The deployment has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is
         * deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
         *        CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy
         *        User Guide</a>.</p>
         *        <p>
         *        The error code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        APPLICATION_MISSING: The application was missing. This error code is most likely raised if the
         *        application is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if
         *        the deployment group is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         *        instance health constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         *        constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_MISSING: The service role cannot be accessed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INTERNAL_ERROR: There was an internal error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_INSTANCES: No instances were specified, or no instances can be found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of
         *        one or more Amazon Web Services services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: The deployment has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision
         *        is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
         * CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User
         * Guide</a>.
         * </p>
         * <p>
         * The error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is
         * deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the
         * deployment group is deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         * instance health constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         * constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_MISSING: The service role cannot be accessed.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * INTERNAL_ERROR: There was an internal error.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_INSTANCES: No instances were specified, or no instances can be found.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or
         * more Amazon Web Services services.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: The deployment has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is
         * deleted after the deployment is created, but before it is started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for
         *        CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy
         *        User Guide</a>.</p>
         *        <p>
         *        The error code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        APPLICATION_MISSING: The application was missing. This error code is most likely raised if the
         *        application is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if
         *        the deployment group is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         *        instance health constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         *        constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_MISSING: The service role cannot be accessed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INTERNAL_ERROR: There was an internal error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_INSTANCES: No instances were specified, or no instances can be found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of
         *        one or more Amazon Web Services services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: The deployment has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision
         *        is deleted after the deployment is created, but before it is started.
         *        </p>
         *        </li>
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(ErrorCode code);

        /**
         * <p>
         * An accompanying error message.
         * </p>
         * 
         * @param message
         *        An accompanying error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInformation model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ErrorInformation build() {
            return new ErrorInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
