/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentConfigRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, CreateDeploymentConfigRequest> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::deploymentConfigName)).setter(CreateDeploymentConfigRequest.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::minimumHealthyHosts)).setter(CreateDeploymentConfigRequest.setter(Builder::minimumHealthyHosts)).constructor(MinimumHealthyHosts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build()}).build();
    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::trafficRoutingConfig)).setter(CreateDeploymentConfigRequest.setter(Builder::trafficRoutingConfig)).constructor(TrafficRoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::computePlatformAsString)).setter(CreateDeploymentConfigRequest.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_NAME_FIELD, MINIMUM_HEALTHY_HOSTS_FIELD, TRAFFIC_ROUTING_CONFIG_FIELD, COMPUTE_PLATFORM_FIELD));
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;
    private final TrafficRoutingConfig trafficRoutingConfig;
    private final String computePlatform;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
        this.computePlatform = builder.computePlatform;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    public TrafficRoutingConfig trafficRoutingConfig() {
        return this.trafficRoutingConfig;
    }

    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public String computePlatformAsString() {
        return this.computePlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficRoutingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest)((Object)obj);
        return Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts()) && Objects.equals(this.trafficRoutingConfig(), other.trafficRoutingConfig()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeploymentConfigRequest").add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("MinimumHealthyHosts", (Object)this.minimumHealthyHosts()).add("TrafficRoutingConfig", (Object)this.trafficRoutingConfig()).add("ComputePlatform", (Object)this.computePlatformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyHosts()));
            }
            case "trafficRoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.trafficRoutingConfig()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentConfigRequest, T> g) {
        return obj -> g.apply((CreateDeploymentConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;
        private TrafficRoutingConfig trafficRoutingConfig;
        private String computePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            super(model);
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
            this.trafficRoutingConfig(model.trafficRoutingConfig);
            this.computePlatform(model.computePlatform);
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return this.trafficRoutingConfig != null ? this.trafficRoutingConfig.toBuilder() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts)).build());
        }

        public Builder trafficRoutingConfig(TrafficRoutingConfig var1);

        default public Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return this.trafficRoutingConfig((TrafficRoutingConfig)((TrafficRoutingConfig.Builder)TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig)).build());
        }

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

