/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentTargetType {
    INSTANCE_TARGET("InstanceTarget"),
    LAMBDA_TARGET("LambdaTarget"),
    ECS_TARGET("ECSTarget"),
    CLOUD_FORMATION_TARGET("CloudFormationTarget"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentTargetType> VALUE_MAP;
    private final String value;

    private DeploymentTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentTargetType> knownValues() {
        EnumSet<DeploymentTargetType> knownValues = EnumSet.allOf(DeploymentTargetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentTargetType.class, DeploymentTargetType::toString);
    }
}

