/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentOption {
    WITH_TRAFFIC_CONTROL("WITH_TRAFFIC_CONTROL"),
    WITHOUT_TRAFFIC_CONTROL("WITHOUT_TRAFFIC_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentOption> VALUE_MAP;
    private final String value;

    private DeploymentOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentOption> knownValues() {
        EnumSet<DeploymentOption> knownValues = EnumSet.allOf(DeploymentOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentOption.class, DeploymentOption::toString);
    }
}

