/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;

public class ListDeploymentGroupsPublisher
implements SdkPublisher<ListDeploymentGroupsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListDeploymentGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentGroupsPublisher(CodeDeployAsyncClient client, ListDeploymentGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentGroupsPublisher(CodeDeployAsyncClient client, ListDeploymentGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> deploymentGroups() {
        Function<ListDeploymentGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentGroups() != null) {
                return response.deploymentGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeploymentGroupsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentGroupsResponse> {
        private ListDeploymentGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentGroupsResponse> nextPage(ListDeploymentGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentGroupsPublisher.this.client.listDeploymentGroups(ListDeploymentGroupsPublisher.this.firstRequest);
            }
            return ListDeploymentGroupsPublisher.this.client.listDeploymentGroups((ListDeploymentGroupsRequest)((Object)ListDeploymentGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

