/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDeploymentGroupsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
    private static final SdkField<List<DeploymentGroupInfo>> DEPLOYMENT_GROUPS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentGroupsInfo").getter(BatchGetDeploymentGroupsResponse.getter(BatchGetDeploymentGroupsResponse::deploymentGroupsInfo)).setter(BatchGetDeploymentGroupsResponse.setter(Builder::deploymentGroupsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(BatchGetDeploymentGroupsResponse.getter(BatchGetDeploymentGroupsResponse::errorMessage)).setter(BatchGetDeploymentGroupsResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_GROUPS_INFO_FIELD, ERROR_MESSAGE_FIELD));
    private final List<DeploymentGroupInfo> deploymentGroupsInfo;
    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    public boolean hasDeploymentGroupsInfo() {
        return this.deploymentGroupsInfo != null && !(this.deploymentGroupsInfo instanceof SdkAutoConstructList);
    }

    public List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return this.deploymentGroupsInfo;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse)((Object)obj);
        return Objects.equals(this.deploymentGroupsInfo(), other.deploymentGroupsInfo()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDeploymentGroupsResponse").add("DeploymentGroupsInfo", this.deploymentGroupsInfo()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentGroupsInfo": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupsInfo()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentGroupsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            super(model);
            this.deploymentGroupsInfo(model.deploymentGroupsInfo);
            this.errorMessage(model.errorMessage);
        }

        public final Collection<DeploymentGroupInfo.Builder> getDeploymentGroupsInfo() {
            return this.deploymentGroupsInfo != null ? (Collection)this.deploymentGroupsInfo.stream().map(DeploymentGroupInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo ... deploymentGroupsInfo) {
            this.deploymentGroupsInfo(Arrays.asList(deploymentGroupsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder> ... deploymentGroupsInfo) {
            this.deploymentGroupsInfo(Stream.of(deploymentGroupsInfo).map(c -> (DeploymentGroupInfo)((DeploymentGroupInfo.Builder)DeploymentGroupInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo.BuilderImpl> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copyFromBuilder(deploymentGroupsInfo);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        public Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> var1);

        public Builder deploymentGroupsInfo(DeploymentGroupInfo ... var1);

        public Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder> ... var1);

        public Builder errorMessage(String var1);
    }
}

